DECLARE SUB BoxWindow3 (W3 AS ANY, colr%)
DECLARE SUB SetWindow3 (W3 AS ANY, x0%, y0%, z0%, x1%, y1%, z1%)
DECLARE SUB SetMaxWindow ()
DECLARE FUNCTION GetKey$ (waitfor%)

DEFINT A-Z
REM $INCLUDE: 'BI\QBEVGFX.BI'

SUB BoxWindow3 (W3 AS WINDOW3Dtype, colr)

x0 = W3.x0 - 1: y0 = W3.y0 - 1: x1 = W3.x1 + 1: y1 = W3.y1 + 1
SETSTEP x0, y0
DRAWLNS 0, colr, x1, y0
DRAWLNS 0, colr, x1, y1
DRAWLNS 0, colr, x0, y1
DRAWLNS 0, colr, x0, y0

END SUB

SUB DoROTATE3D (T3 AS PACK3Dtype, W3 AS WINDOW3Dtype, MaxX, MaxY)

REDIM opts(0 TO 11) AS LINE3Dtype
REDIM ppts(0 TO 11) AS LINE3Dtype
REDIM jpts(0 TO 11) AS LINE2Dtype
REDIM dpts(0 TO 11) AS LINE2Dtype

opts(0).x0 = 0: opts(0).y0 = 0: opts(0).z0 = 1
opts(0).x1 = 80: opts(0).y1 = 0: opts(0).z1 = 1

opts(1).x0 = 80: opts(1).y0 = 0: opts(1).z0 = 1
opts(1).x1 = 80: opts(1).y1 = 80: opts(1).z1 = 1

opts(2).x0 = 80: opts(2).y0 = 80: opts(2).z0 = 1
opts(2).x1 = 0: opts(2).y1 = 80: opts(2).z1 = 1

opts(3).x0 = 0: opts(3).y0 = 80: opts(3).z0 = 1
opts(3).x1 = 0: opts(3).y1 = 0: opts(3).z1 = 1

opts(4).x0 = 0: opts(4).y0 = 0: opts(4).z0 = 1
opts(4).x1 = 0: opts(4).y1 = 0: opts(4).z1 = 80

opts(5).x0 = 0: opts(5).y0 = 0: opts(5).z0 = 80
opts(5).x1 = 80: opts(5).y1 = 0: opts(5).z1 = 80

opts(6).x0 = 80: opts(6).y0 = 0: opts(6).z0 = 80
opts(6).x1 = 80: opts(6).y1 = 80: opts(6).z1 = 80

opts(7).x0 = 80: opts(7).y0 = 80: opts(7).z0 = 80
opts(7).x1 = 0: opts(7).y1 = 80: opts(7).z1 = 80

opts(8).x0 = 0: opts(8).y0 = 80: opts(8).z0 = 80
opts(8).x1 = 0: opts(8).y1 = 0: opts(8).z1 = 80

opts(9).x0 = 0: opts(9).y0 = 80: opts(9).z0 = 1
opts(9).x1 = 0: opts(9).y1 = 80: opts(9).z1 = 80

opts(10).x0 = 80: opts(10).y0 = 80: opts(10).z0 = 80
opts(10).x1 = 80: opts(10).y1 = 80: opts(10).z1 = 1

opts(11).x0 = 80: opts(11).y0 = 0: opts(11).z0 = 1
opts(11).x1 = 80: opts(11).y1 = 0: opts(11).z1 = 80

MaxTimes = 3600
SetWindow3 W3, 200, 56, 0, MaxX - 1, MaxY - 1, 0
pmode = 0
GOSUB ResetInit
vseg = VARSEG(T3): voff = VARPTR(T3)
XFORM3D vseg, voff
IF pmode THEN PROJORTHO vseg, voff ELSE PROJPERS vseg, voff
FOR i = 0 TO (T3.points3 \ 2) - 1: dpts(i) = jpts(i): NEXT
DO
   IF auto THEN T3.degH3 = (T3.degH3 + inc) MOD 360: IF T3.degH3 > 23040 THEN T3.degH3 = 0
   XFORM3D vseg, voff
   IF pmode THEN PROJORTHO vseg, voff ELSE PROJPERS vseg, voff
   FOR i = 0 TO (T3.points3 \ 2) - 1
      in = CLIP3D(VARSEG(dpts(i)), VARPTR(dpts(i)))
      IF in THEN DRAWLN 0, 0, dpts(i).x0, dpts(i).y0, dpts(i).x1, dpts(i).y1
      in = CLIP3D(VARSEG(jpts(i)), VARPTR(jpts(i)))
      IF in THEN DRAWLN 0, culur, jpts(i).x0, jpts(i).y0, jpts(i).x1, jpts(i).y1
      dpts(i) = jpts(i)
   NEXT
   IF vs THEN WAITVS vs * vst
   GOSUB Chkey
LOOP UNTIL in$ = CHR$(27) OR nokey > MaxTimes

SetMaxWindow
k$ = GetKey$(-1)
EXIT SUB

Chkey:
in$ = INKEY$
IF LEN(in$) = 0 THEN nokey = nokey + 1: RETURN
nokey = 0
MaxTimes = 29999
SELECT CASE LEFT$(in$, 1)
CASE "h"
   auto = 0
   T3.degH3 = T3.degH3 - 1
   IF T3.degH3 < 0 THEN T3.degH3 = 359
   nx = DRAWSTR(0, STR$(T3.degH3) + "  ", 112, 98, 7, 0, 8)
CASE "H"
   auto = 0
   T3.degH3 = T3.degH3 + 1
   IF T3.degH3 > 359 THEN T3.degH3 = 0
   nx = DRAWSTR(0, STR$(T3.degH3) + "  ", 112, 98, 7, 0, 8)
CASE "p"
   T3.degP3 = T3.degP3 - 1
   IF T3.degP3 < 0 THEN T3.degP3 = 359
   nx = DRAWSTR(0, STR$(T3.degP3) + "  ", 96, 112, 7, 0, 8)
CASE "P"
   T3.degP3 = T3.degP3 + 1
   IF T3.degP3 > 359 THEN T3.degP3 = 0
   nx = DRAWSTR(0, STR$(T3.degP3) + "  ", 96, 112, 7, 0, 8)
CASE "b"
   T3.degB3 = T3.degB3 - 1
   IF T3.degB3 < 0 THEN T3.degB3 = 359
   nx = DRAWSTR(0, STR$(T3.degB3) + "  ", 88, 126, 7, 0, 8)
CASE "B"
   T3.degB3 = T3.degB3 + 1
   IF T3.degB3 > 359 THEN T3.degB3 = 0
   nx = DRAWSTR(0, STR$(T3.degB3) + "  ", 88, 126, 7, 0, 8)
CASE "x"
   T3.TransX3 = T3.TransX3 - 10
   txt$ = STR$(T3.TransX3 - T3.orgX3) + " "
   nx = DRAWSTR(0, txt$, 144, 140, 7, 0, 8)
CASE "X"
   T3.TransX3 = T3.TransX3 + 10
   txt$ = STR$(T3.TransX3 - T3.orgX3) + " "
   nx = DRAWSTR(0, txt$, 144, 140, 7, 0, 8)
CASE "y"
   T3.TransY3 = T3.TransY3 - 10
   txt$ = STR$(T3.TransY3 - T3.orgY3) + " "
   nx = DRAWSTR(0, txt$, 144, 154, 7, 0, 8)
CASE "Y"
   T3.TransY3 = T3.TransY3 + 10
   txt$ = STR$(T3.TransY3 - T3.orgY3) + " "
   nx = DRAWSTR(0, txt$, 144, 154, 7, 0, 8)
CASE "z"
   T3.TransZ3 = T3.TransZ3 - 10
   txt$ = STR$(T3.TransZ3 - T3.orgZ3) + " "
   nx = DRAWSTR(0, txt$, 144, 168, 7, 0, 8)
CASE "Z"
   T3.TransZ3 = T3.TransZ3 + 10
   txt$ = STR$(T3.TransZ3 - T3.orgZ3) + " "
   nx = DRAWSTR(0, txt$, 144, 168, 7, 0, 8)
CASE "s"
   T3.ScaleX3 = T3.ScaleX3 - 1
   T3.ScaleY3 = T3.ScaleY3 - 1
   T3.ScaleZ3 = T3.ScaleZ3 - 1
   IF T3.ScaleZ3 < 1 THEN T3.ScaleZ3 = 1: T3.ScaleY3 = 1: T3.ScaleX3 = 1
   txt$ = STR$(T3.ScaleX3) + "% "
   nx = DRAWSTR(0, txt$, 128, 182, 7, 0, 8)
CASE "S"
   T3.ScaleX3 = T3.ScaleX3 + 1
   T3.ScaleY3 = T3.ScaleY3 + 1
   T3.ScaleZ3 = T3.ScaleZ3 + 1
   IF T3.ScaleZ3 > 150 THEN T3.ScaleZ3 = 150: T3.ScaleY3 = 150: T3.ScaleX3 = 150
   txt$ = STR$(T3.ScaleX3) + "% "
   nx = DRAWSTR(0, txt$, 128, 182, 7, 0, 8)
CASE "d"
   T3.distV3 = T3.distV3 - 10
   txt$ = STR$(T3.orgZ3 + T3.distV3) + " "
   IF pmode = 0 THEN nx = DRAWSTR(0, txt$, 120, 196, 7, 0, 8)
CASE "D"
   T3.distV3 = T3.distV3 + 10
   txt$ = STR$(T3.orgZ3 + T3.distV3) + " "
   IF pmode = 0 THEN nx = DRAWSTR(0, txt$, 120, 196, 7, 0, 8)
CASE "i"
   inc = inc - 1: IF inc < 0 THEN inc = 0
   nx = DRAWSTR(0, STR$(inc), 152, 210, 7, 0, 8)
CASE "I"
   inc = inc + 1: IF inc > 9 THEN inc = 9
   nx = DRAWSTR(0, STR$(inc), 152, 210, 7, 0, 8)
CASE "v"
   vs = vs - 1: IF vs < 1 THEN vs = 0
   nx = DRAWSTR(0, STR$(vs * vst), 168, 224, 7, 0, 8)
CASE "V"
   vs = vs + 1: IF vs > 9 THEN vs = 9
   nx = DRAWSTR(0, STR$(vs * vst), 168, 224, 7, 0, 8)
CASE "w"
   SEVS = NOT SEVS: IF SEVS THEN vst = 1 ELSE vst = -1
   nx = DRAWSTR(0, STR$(vs * vst), 168, 224, 7, 0, 8)
CASE "c"
   culur = culur - 1: IF culur < 1 THEN culur = 1
   nx = DRAWSTR(0, STR$(culur) + " ", 144, 238, 7, 0, 8)
CASE "C"
   culur = culur + 1: IF culur > 15 THEN culur = 15
   nx = DRAWSTR(0, STR$(culur) + " ", 144, 238, 7, 0, 8)
CASE "r", "R"
   GOSUB ResetInit
CASE "a", "A"
   auto = NOT auto
   IF auto THEN txt$ = " Auto" ELSE txt$ = STR$(T3.degH3) + "   "
   nx = DRAWSTR(0, txt$, 112, 98, 7, 0, 8)
CASE "j", "J"
   pmode = NOT pmode
   IF pmode = 0 THEN txt$ = "D/d   distance" + STR$(T3.distV3 + T3.orgZ3) ELSE txt$ = SPACE$(21)
   nx = DRAWSTR(0, txt$, 0, 196, 7, 0, 8)
CASE CHR$(0)
   SELECT CASE ASC(RIGHT$(in$, 1))
   CASE 77
      T3.orgX3 = T3.orgX3 + 2
      T3.TransX3 = T3.TransX3 + 2
   CASE 75
      T3.orgX3 = T3.orgX3 - 2
      T3.TransX3 = T3.TransX3 - 2
   CASE 72
      T3.orgY3 = T3.orgY3 - 2
      T3.TransY3 = T3.TransY3 - 2
   CASE 80
      T3.orgY3 = T3.orgY3 + 2
      T3.TransY3 = T3.TransY3 + 2
   CASE 116
      T3.orgZ3 = T3.orgZ3 + 2
      T3.TransZ3 = T3.TransZ3 + 2
   CASE 115
      T3.orgZ3 = T3.orgZ3 - 2
      T3.TransZ3 = T3.TransZ3 - 2
   CASE ELSE
  
   END SELECT
   txt$ = STR$(T3.orgX3) + STR$(T3.orgY3) + STR$(T3.orgZ3) + " "
   nx = DRAWSTR(0, txt$, 72, 84, 7, 0, 8)
   txt$ = STR$(T3.distV3 + T3.orgZ3) + " "
   IF pmode = 0 THEN nx = DRAWSTR(0, txt$, 120, 196, 7, 0, 8)
CASE ELSE
   nokey = nokey + 1: IF nokey > 32000 THEN auto = -1: nokey = 0
END SELECT
RETURN

ResetInit:
FILLSCN 0, MaxY + 1, 0
BoxWindow3 W3, 7
T3.xtype3 = 0
T3.degH3 = 340
T3.degP3 = 0
T3.degB3 = 0
T3.orgX3 = MaxX \ 2
T3.orgY3 = MaxY \ 2
T3.orgZ3 = -100                 'best if we stay on neg side of z-axis
T3.TransX3 = T3.orgX3 - 40      'cube is 80x80x80 pixels
T3.TransY3 = T3.orgY3 - 40
T3.TransZ3 = T3.orgZ3 - 40
T3.ScaleX3 = 100
T3.ScaleY3 = 100
T3.ScaleZ3 = 100
T3.distV3 = 400
T3.points3 = 24                 'lines 0-11
T3.segXY3 = VARSEG(opts(0))
T3.offXY3 = VARPTR(opts(0))
T3.segXYp3 = VARSEG(ppts(0))
T3.offXYp3 = VARPTR(ppts(0))
T3.segXYj3 = VARSEG(jpts(0))
T3.offXYj3 = VARPTR(jpts(0))
auto = -1
inc = 1
vs = 0
culur = 7
vst = 1: SEVS = -1  '-1 wait til start of VS  0 wait til end of VS
vseg = VARSEG(T3): voff = VARPTR(T3)
XFORM3D vseg, voff
IF pmode THEN PROJORTHO vseg, voff ELSE PROJPERS vseg, voff
FONTGUI14
txt$ = "XFORM3D(VARSEG(Struc3D),VARPTR(Struc3D)    Transform points in 3D"
nx = DRAWSTR(0, txt$, 0, 0, 7, 0, 0)
txt$ = "PROJORTHO(VARSEG(Struc3D),VARPTR(Struc3D)    Orthographic projection"
nx = DRAWSTR(0, txt$, 0, 14, 7, 0, 0)
txt$ = "PROJPERS(VARSEG(Struc3D),VARPTR(Struc3D)    Perspective projection"
nx = DRAWSTR(0, txt$, 0, 28, 7, 0, 0)
FONTSYS14

txt$ = "3D-Controls"
nx = DRAWSTR(0, txt$, 16, 56, 5, 0, 8)
txt$ = "^   RC" + STR$(T3.orgX3) + STR$(T3.orgY3) + STR$(T3.orgZ3)
nx = DRAWSTR(0, txt$, 0, 84, 7, 0, 8)
txt$ = "H/h   heading" + STR$(T3.degH3)
nx = DRAWSTR(0, txt$, 0, 98, 7, 0, 8)
txt$ = "P/p   pitch" + STR$(T3.degP3)
nx = DRAWSTR(0, txt$, 0, 112, 7, 0, 8)
txt$ = "B/b   bank" + STR$(T3.degB3)
nx = DRAWSTR(0, txt$, 0, 126, 7, 0, 8)
txt$ = "X/x   translate x" + STR$(T3.TransX3 - T3.orgX3)
nx = DRAWSTR(0, txt$, 0, 140, 7, 0, 8)
txt$ = "Y/y   translate y" + STR$(T3.TransY3 - T3.orgY3)
nx = DRAWSTR(0, txt$, 0, 154, 7, 0, 8)
txt$ = "Z/z   translate z" + STR$(T3.TransZ3 - T3.orgZ3)
nx = DRAWSTR(0, txt$, 0, 168, 7, 0, 8)
txt$ = "S/s   scale xyz" + STR$(T3.ScaleX3) + "%"
nx = DRAWSTR(0, txt$, 0, 182, 7, 0, 8)
txt$ = "D/d   distance" + STR$(T3.distV3 + T3.orgZ3)
IF pmode = 0 THEN nx = DRAWSTR(0, txt$, 0, 196, 7, 0, 8)
txt$ = "I/i   rotation inc" + STR$(inc)
nx = DRAWSTR(0, txt$, 0, 210, 7, 0, 8)
txt$ = "V/v   vert sync wait" + STR$(vs * vst)
nx = DRAWSTR(0, txt$, 0, 224, 7, 0, 8)
txt$ = "C/c   color value" + STR$(culur)
nx = DRAWSTR(0, txt$, 0, 238, 7, 0, 8)
txt$ = "a    toggle autorotate"
nx = DRAWSTR(0, txt$, 0, 252, 7, 0, 8)
txt$ = "j    toggle projection"
nx = DRAWSTR(0, txt$, 0, 266, 7, 0, 8)
txt$ = "r    reset"
nx = DRAWSTR(0, txt$, 0, 280, 7, 0, 8)
txt$ = "Esc  quit"
nx = DRAWSTR(0, txt$, 0, 294, 7, 0, 8)
txt$ = "Adjust the vert sync if"
nx = DRAWSTR(0, txt$, 0, 320, 4, 0, 8)
txt$ = "the cube is not visible"
nx = DRAWSTR(0, txt$, 0, 334, 4, 0, 8)
RETURN

END SUB

SUB SetWindow3 (W3 AS WINDOW3Dtype, x0, y0, z0, x1, y1, z1)

W3.x0 = x0: W3.y0 = y0: W3.z0 = z0: W3.x1 = x1: W3.y1 = y1: W3.z1 = z1
wseg = VARSEG(W3): woff = VARPTR(W3)
SETWIN3D wseg, woff

END SUB

