{ menu definitions for SAMPLER.PAS  R.M. 28/3/89}

{$define sample}

Const
  noheadings     = 6;
  maxverticalbars = 10;
  menustringlength = 20;
  cornersize     = 20;
  menuxoffset    = cornersize;
  menubcolor     = white;
  menucolor      = black;
  menuinvisiblecolor = cyan;
  menufont       = smallfont;
  menufontsize   = 4;

Type menuselectiontype =
  (options, settings, _help,
   _file, directory, read_sound_file, write_sound_file, quit_to_dos,
   edit, cut, clear, _copy, paste, mix, mirror_segment, _scale_envelope, _zoom,
    _sample,
   _song, play_song, read_song_file,
   miscellaneous, concert_a, monitor,
   play_sound,
   inactive);

  menuentrytype = Record
                    selection      : menuselectiontype;
                    title          : String[menustringlength];
                    visible        : Boolean;
                  End;

  menustructuretype = Array[1..noheadings]
                        Of Record
                             nentries       : Byte;
                             entry          : Array[1..maxverticalbars] Of
                             menuentrytype;
                           End;

Const
  menustructure : menustructuretype =
  ((nentries : 3; entry :
   ((selection : options; title : 'Options'; visible : True),
    (selection : settings; title : 'Settings'; visible : True),
    (selection : _help; title : 'Help'; visible : True),
    (selection : inactive; title : ''; visible : True),
    (selection : inactive; title : ''; visible : True),
    (selection : inactive; title : ''; visible : True),
    (selection : inactive; title : ''; visible : True),
    (selection : inactive; title : ''; visible : True),
    (selection : inactive; title : ''; visible : True),
    (selection : inactive; title : ''; visible : True))),
  (nentries : 5; entry :
   ((selection : _file; title : 'File'; visible : True),
    (selection : directory; title : 'Directory'; visible : True),
    (selection : read_sound_file; title : 'Read sound file'; visible : True),
    (selection : write_sound_file; title : 'Write sound file'; visible : True),
    (selection : quit_to_dos; title : 'Quit to DOS'; visible : True),
    (selection : inactive; title : ''; visible : True),
    (selection : inactive; title : ''; visible : True),
    (selection : inactive; title : ''; visible : True),
    (selection : inactive; title : ''; visible : True),
    (selection : inactive; title : ''; visible : True))),
  (nentries : 10; entry :
   ((selection : edit; title : 'Edit'; visible : True),
    (selection : cut; title : 'Cut'; visible : False),
    (selection : _copy; title : 'Copy'; visible : False),
    (selection : paste; title : 'Paste'; visible : False),
    (selection : mix; title : 'Mix'; visible : False),
    (selection : mirror_segment; title : 'Mirror segment'; visible : False),
    (selection : _scale_envelope; title : 'Scale envelope'; visible : False),
    (selection : clear; title : 'Clear'; visible : False),
    (selection : _zoom; title : 'Zoom'; visible : False),
{$ifndef sample}
    (selection : _sample; title : 'Sample'; visible : false))),
{$else}
    (selection : _sample; title : 'Sample'; visible : True))),
{$endif}
  (nentries : 3; entry :
   ((selection : _song; title : 'Song'; visible : True),
    (selection : play_song; title : 'Play song'; visible : False),
    (selection : read_song_file; title : 'Read song file'; visible : True),
    (selection : inactive; title : ''; visible : True),
    (selection : inactive; title : ''; visible : True),
    (selection : inactive; title : ''; visible : True),
    (selection : inactive; title : ''; visible : True),
    (selection : inactive; title : ''; visible : True),
    (selection : inactive; title : ''; visible : True),
    (selection : inactive; title : ''; visible : True))),
  (nentries : 3; entry :
   ((selection : miscellaneous; title : 'Miscellaneous'; visible : True),
    (selection : concert_a; title : 'Concert A'; visible : True),
{$ifndef sample}
    (selection : monitor; title : 'Monitor'; visible : false),
{$else}
    (selection : monitor; title : 'Monitor'; visible : true),
{$endif}
    (selection : inactive; title : ''; visible : True),
    (selection : inactive; title : ''; visible : True),
    (selection : inactive; title : ''; visible : True),
    (selection : inactive; title : ''; visible : True),
    (selection : inactive; title : ''; visible : True),
    (selection : inactive; title : ''; visible : True),
    (selection : inactive; title : ''; visible : True))),
  (nentries : 1; entry :
   ((selection : play_sound; title : 'Play sound'; visible : True),
    (selection : inactive; title : ''; visible : True),
    (selection : inactive; title : ''; visible : True),
    (selection : inactive; title : ''; visible : True),
    (selection : inactive; title : ''; visible : True),
    (selection : inactive; title : ''; visible : True),
    (selection : inactive; title : ''; visible : True),
    (selection : inactive; title : ''; visible : True),
    (selection : inactive; title : ''; visible : True),
    (selection : inactive; title : ''; visible : True))));


