: -- main Profile program
: -- declare used variables
type v cmeas clarge csmall cstart cfit1 cfit2 $
var real vbi const power $
: -- get measurement data and compensate side-effects
get spl.cv v clarge $
get sps.cv v csmall $
cmeas = clarge-2*csmall
: -- define models
define cmodel1 = const/((vbi-v)~(0.5))
define cmodel2 = const/((vbi-v)~(power))
: define cmodel1 = (const*8e-12)/((vbi-v)~(0.5))
: define cmodel2 = (const*8e-12)/((vbi-v)~(power))
: -- give constraints
constrain vbi   0.3 2.0
constrain power 0.1 1.0
: -- give starting values
const = 8e-12 
: const = 1
vbi   = 1.0
power = 0.5
: -- calculate starting capacity for model1
cstart = cmodel1
: -- set parameters 
setlm talk 2
weight = 1/cmeas
: -- start optimization for model1
levmar def cmodel1 cmeas v cfit1 const vbi $
: -- show results
const
vbi
pause
: -- start optimization for model2
levmar def cmodel2 cmeas v cfit2 const vbi power $
view v cstart cmeas cfit1 cfit2 $
