function INREAL (var Filin: text; var Realvar: vartype; var Comment: text80;
  Line_num: integer; Interactive: boolean): integer;

{ Read in a line from or standard Input, and decode the
  numeric input in a reasonable way (similar to Fortran). Allow a trailing
  decimal point, commas between entries, and any number of spaces or tabs.
  If an asterisk is encountered on the line, everything after it is taken
  to be a comment. If the line begins with an asterisk, then the entire
  line is taken to be a comment and another line is read immediately
  WITHOUT EVER RETURNING THE FIRST COMMENT TO THE CALLING PROGRAM.
  To read from standard Input, instead of from a file,
  set the Interactive flag to TRUE (otherwise FALSE).  If not Interactive,
  then INREAL never returns 0 variables; it always reads another line.
  If Interactive, then 0 variables is a legal return.
}
var Line: string[127];            { line of input }
    i: integer;                   { points to character in Line }
    j: integer;                   { general index }
    Num: integer;                 { number of numeric entry }
    Firstdig: integer;            { pointer to first digit of entry }
    Lennum: integer;              { length of total numeric entry }
    Ndeci: integer;               { # decimal pts. in entry }
    Retcode: integer;             { return code from function }
    Lastcomma: boolean;           { keep track of whether last significant
                                    character was a comma }

begin
  Lastcomma := TRUE;
  Comment := '';
  Num := 0;
  Line := '*';
  while (Line[1] = '*') do begin
    if (Interactive) then begin
      readln (Line);
      if (length(Line) = 0) then
        Line[1] := ' ';
    end
    else
      readln (Filin, Line);
  end;
  Line[length(Line)+1] := ' ';
  i := 1;
  while (i <= length(Line)) and (Num < MAXVAR) and (Num >= 0) do begin
    if (Line[i] = ' ') or (Line[i] = ^I) or (Line[i] = ',') or
       (Line[i] = ^M) then begin
      if (Lastcomma) and (Line[i] = ',') then begin
        { Two commas in a row: a 0 input }
        Num := Num + 1;
        Realvar[Num] := 0;
      end
      else if (Line[i] = ',') then
        Lastcomma := TRUE;
      i := i + 1;
    end
    else if ((Line[i] <= '9') and (Line[i] >= '0')) or (Line[i] = '.') or
            (Line[i] = '-') then begin
      Lastcomma := FALSE;
      Num := Num + 1;
      Firstdig := i;
      Lennum := 1;
      i := i + 1;
      while (i <= length(Line)) and (((Line[i] <= '9') and (Line[i] >= '0'))
            or (Line[i] = '.') or (Line[i] = 'E') or (Line[i] = 'e')
            or (Line[i] = '-') or (Line[i] = '+')) do begin
        Lennum := Lennum + 1;
        i := i + 1;
      end;
      if Line[i] = '.' then
        { Remove trailing decimal point }
        Lennum := Lennum - 1;
      if (Lennum < 1) then
        { Flag bad entry }
        Num := -i
      else begin

        { silly code to convert to 4.0 so -.1 and 1. work }
        if (lennum > 0) and (line[firstdig + lennum - 1] = '.') then
          lennum := lennum - 1;
        if line[Firstdig] = '.' then
          val ('0'+copy (Line, Firstdig, Lennum), Realvar[Num], Retcode)
        else if (line[firstdig] = '-') and (line[firstdig + 1] = '.') then
          val ('-0' + copy (Line, Firstdig + 1, Lennum - 1),
              Realvar[Num], Retcode)
        else
          val (copy (Line, Firstdig, Lennum), Realvar[Num], Retcode);
        if (Retcode > 0) then begin
          Num := -(Firstdig + Retcode - 1);
        end;
      end;
    end else if (Line[i] = '*') then begin
      Comment := copy(Line, i+1, length(Line)-i);
      i := length(Line) + 1;    { just to stop the while loop }
    end else
      Num := -i;  { flag bad character }
  end; {while}

  if (Num < 0) then begin
    if (Line_num > 0) then
      writeln ('Bad input found in line ', Line_num,':')
    else
      writeln ('Bad input:');
    writeln (Line);
    for j := 1 to (-Num-1) do
      write ('-');
    write ('^');
    for j := (-Num+1) to length(Line) do
      write ('-');
    writeln;
    writeln ('Numeric input was expected.');
    writeln ('(The carat (^) points to the bad character.)');
  end; { if Num }

  Inreal := Num;
end; { function Inreal }
