procedure PATCH;
{ option to break all 16-node surfaces into 9 4-node surfaces
  NOTE: When time allows, this routine needs to be extended to properly
  treat a spline.
}

var Node:                integer;      { node # }
    Surf:                integer;      { surface # }
    Tnsurf:              integer;      { temp for Nsurf }
    Nvertex:             integer;      { # vertices in Surf }

procedure BREAKPATCH (Oldsurf, Vert1, Vert2, Vert3, Vert4, Newsurf: integer);
{ Makes a new quadrilateral surface using the four vertices specifed from
  the old 16-sided surface }

begin
{$ifdef BIGMEM}
with ptrb^ do with ptrc^ do
begin
{$endif}
  Connect[(Newsurf-1) * Maxvert + 1] := konnec (Oldsurf, Vert1);
  Connect[(Newsurf-1) * Maxvert + 2] := konnec (Oldsurf, Vert2);
  Connect[(Newsurf-1) * Maxvert + 3] := konnec (Oldsurf, Vert3);
  Connect[(Newsurf-1) * Maxvert + 4] := konnec (Oldsurf, Vert4);
  Connect[(Newsurf-1) * Maxvert + 5] := 0;
  Matl[Newsurf] := Matl[Oldsurf];
{$ifdef BIGMEM}
end; {with}
{$endif}
end; { procedure BREAKPATCH }

begin
  Tnsurf := Nsurf;
  for Surf := 1 to Nsurf do begin
    Nvertex := Nvert(Surf);
    if (Nvertex = 16) then begin
      if ((Tnsurf+8) * Maxvert > MAXCONNECT) then begin
        writeln ('Error: Too many surfaces.');
        writeln ('Can"t break the patch into quads.');
        halt;
      end;
      breakpatch (Surf, 1, 2, 6, 5, Tnsurf+1);
      breakpatch (Surf, 2, 3, 7, 6, Tnsurf+2);
      breakpatch (Surf, 3, 4, 8, 7, Tnsurf+3);
      breakpatch (Surf, 5, 6, 10, 9, Tnsurf+4);
      breakpatch (Surf, 6, 7, 11, 10, Tnsurf+5);
      breakpatch (Surf, 7, 8, 12, 11, Tnsurf+6);
      breakpatch (Surf, 9, 10, 14, 13, Tnsurf+7);
      breakpatch (Surf, 10, 11, 15, 14, Tnsurf+8);
{ Note: It's important that the last quad not use the first five nodes
  or else there could be a conflict. }
      breakpatch (Surf, 11, 12, 16, 15, Surf);
      Tnsurf := Tnsurf + 8;
    end; { if Nvertex }
  end; { for Surf }
  Nsurf := Tnsurf;
  { Flag the patch break so WRITEFILE will check all the surfaces before
    writing the data and see if Maxvert can be reduced
  }
  Checkmax := TRUE;
end; { procedure PATCH }
