{$A+,B-,D-,E-,F-,G-,I-,L-,N-,O-,R-,S-,V+,X-}
{$M 4096,0,655360}
UNIT Caches;

{ Caches tries to determine the size of a first and a second level cache, if
  either is present. This is done by having the external function TestCache
  (or TestCache2 if the CPU is a 286 processor) perform block moves on the
  the same memory block *twice*. Block size starts with 512 bytes and is doubled
  in every iteration until block size is 512 kB. If the memory thruput drops
  sharply after a increase in block size, it is safe to assume that the
  previous block still fit into the cache, while the current block was to
  large to fit into the cache. }

INTERFACE

PROCEDURE CacheSize (Debug, I386: BOOLEAN; VAR FirstLevel, SecondLevel: WORD;
                     VAR CacheThru, Cache2Thru, MemThru: REAL);

IMPLEMENTATION

USES Crt;

TYPE CacheInfo    = ARRAY [1..10] OF WORD;
     CacheInfoPtr = ^CacheInfo;

CONST ClockFreq = 1.193182e6;

FUNCTION TestCache:   CacheInfoPtr; FAR; EXTERNAL;
FUNCTION TestCach286: CacheInfoPtr; FAR; EXTERNAL;

{$L CACHETST.OBJ}

PROCEDURE CacheSize (Debug, I386: BOOLEAN; VAR FirstLevel, SecondLevel: WORD;
                     VAR CacheThru, Cache2Thru, MemThru: REAL);



VAR LongInfo: ARRAY [0..10] OF LONGINT;
    Info: CacheInfoPtr;
    NrValues, L, MemSize: WORD;

BEGIN
   IF I386 THEN BEGIN
      NrValues := 10;
      Info := TestCache;
      END
   ELSE BEGIN
      NrValues := 7;
      Info := TestCach286;
      END;
   MemSize := 1;
   FOR L := 1 TO NrValues DO BEGIN
      LongInfo [L] := Info^[L];
      WHILE (L <> 1) AND (LongInfo [L] < ((19 * LongInfo [L-1]) DIV 10)) DO
         Inc (LongInfo [L], 65536);
      IF Debug THEN
         WriteLn ('CacheTest', L-1, ': ', LongInfo [L]:10 ,
                   MemSize / (LongInfo [L] / ClockFreq):10:0 ,' kB/s');
      MemSize := MemSize * 2;
   END;
   LongInfo [0]:= LongInfo [1];
   FirstLevel  := 0;
   SecondLevel := 0;
   MemSize     := 1;
   FOR L := 1 TO NrValues DO BEGIN
      IF LongInfo [L] > ((22 * LongInfo [L-1]) DIV 10) THEN BEGIN
         IF FirstLevel = 0 THEN BEGIN
            CacheThru  := 0.5 * MemSize / (LongInfo [L-1] / ClockFreq);
            FirstLevel := MemSize DIV 2
            END
         ELSE IF SecondLevel = 0 THEN BEGIN
            Cache2Thru  := 0.5 * MemSize / (LongInfo [L-1] / ClockFreq);
            SecondLevel := MemSize DIV 2;
            END;
         END;
      IF L = NrValues THEN BEGIN
         MemThru := 1.0 * MemSize / (LongInfo [L] / ClockFreq);
         END;
      Inc (MemSize, MemSize);
   END;
END;

END.
