title "UART Detector"
page 60, 132

; comments -- the WRITE function is left up to your own implementation
; v1.1 Toad Hall Tweak, May 91
;	Yeah, well, we can do that.
;	David Kirschbaum
;	Toad Hall
;	kirsch%maxemail@uunet

; constants

BIOSdseg	equ	40h		; data segment for BIOS
i		equ	1		; COM PORT (1-4)

	.model	tiny			; tiny model (.COM)
	.code
	org	100h			; .COM files start at 100h

entry:
	jmp	start			; jump to start of progarm

; variables

xword		dw	?
xbyte2		db	?
xbyte3		db	?

jmp_table   dw      uart_8250_or_16450, uart_unknown, uart_16550, uart_16550a

; ------------------------ MAIN ------------------------------

start	proc
	mov	ax, BIOSdseg
	mov	es, ax			; move bios data segment into ES
	mov	dx, es:[2*i-2]		; get offset for serial port
	mov	xword, dx		; xword := serial port base address
	add	dx, 2			; dx := dx + 2
	in	al, dx			; al := port [dx]
	mov	xbyte2, al		; xbyte2 := al
	mov	al, 0c1h		; al := $C1
	out	dx, al			; port [dx] := al
	in	al, dx			; al := port [dx]
	and	al, 0c0h		; al := (al AND $C0)
	mov	cl, 5			; cl := 5
	shr	al, cl			; al := (al shr 5) (5 for word jmp)
	xor	ah,ah			; ah := 0			v1.1
	mov	bp, ax			; bp := ax (al)
	mov	al, xbyte2		; al := xbyte2
	out	dx, al			; port [dx] := al
	jmp	CS:[jmp_table+bp]	;				v1.1

uart_8250_or_16450:
	mov	dx, xword		; dx := xword
	add	dx, 7			; dx := dx + 7
	in	al, dx			; al := port [dx]
	mov	xbyte2, al		; xbyte2 := al
	mov	al, 0fah		; al := $FA
	out	dx, al			; port [dx] := al
	in	al, dx			; al := port [dx]
	cmp	al, 0fah		; if (al <> $FA)
	jne	uart_16450		; then uart is 16450
	mov	al, 0afh		; al := $AF
	out	dx, al			; port [dx] := al
	in	al, dx			; al := port [dx]
	cmp	al, 0afh		; if (al <> $AF)
	jne	uart_8250		; then uart is 8250
	mov	al, xbyte2		; else al := xbyte2
	out	dx, al			; port [dx] := al
	jmp	short uart_16450	; uart is 16450

uart_8250:
;	write	"8250"			; display "8250"
;	jmp	exit

	call	Exit
	db	'8250$'			; display "8250"

uart_16450:
;	write	"16450"			; display "16450"
;	jmp	exit

	call	Exit
	db	'16450$'		;display "16450"

uart_unknown:
;	write	"???"			; display "unknown"
;	jmp	exit

	call	Exit
	db	'???$'			;display "unknown"

uart_16550:
;	write	"16550"			; display "16550"
;	jmp	exit

	call	Exit
	db	'16550$'		;display "16550"

uart_16550a:
;	write	"16550A"		; display "16550A"
;	jmp	exit

	call	Exit
	db	'16550A$'		;display "16550A"

Exit:
	pop	dx			;msg address			v1.1
	mov	ah,9			;display msg in DX		v1.1
	int	21H			;via DOS			v1.1

	mov	ax, 4c00h		;terminate
	int	21h
start	endp				; end of proc

END	entry				; end of program
