
; Program	: CHKDRV.ASM
; Author	: Infinity Design Concepts Inc. Louisville, Ky 40217-2333
;		: Voice: (502)-636-1234   Data: (502)635-5471
;		  Written by Gary Conway
; Created	: 5/20/90
; Update	: 
; Version	: 1.0
; Notice	:
; MASM 5.1 format


COMMENT	|

	This program will test the drive letter given on the command line
	and return an ERRORLEVEL (testable in BATch files).

	ERRORLEVEL return values
	
		0 - specified drive is ready
		1 - specified drive is NOT ready

	A sample batch file would be constructed as follows,

	ECHO OFF
	REM checking drive A:
	CHKDRV A
	IF ERRORLEVEL 1 GOTO NOTREADY
	ECHO   Drive A: is READY
	GOTO END
	:NOTREADY
	ECHO   Drive A: is NOT READY
	GOTO END
	:END
	


	|


NOTREADY	EQU	1
CR		EQU	13
TAB		EQU	9

CSEG		SEGMENT PARA PUBLIC 'CODE'
		ASSUME CS:CSEG,DS:DSEG,ES:DSEG,SS:STACK
START:
		Mov	AX,DSEG 		; set up segment addresses
		Mov	DS,AX			; data seg.
		Mov	[PSP],ES		; save program segment prefix
		Mov	ES,AX			; extra seg.

		Call	Install_Vectors		; take control of ^C and ^BREAK
						; and critical error ints.
		Call	GetParms		; get command line parms
		Mov	AL,[Parm1]		; get upcase drive letter
		Mov	AH,36h
		Mov	DL,AL			; A: = 1
		Sub	DL,40h
		Int	21h			; get disk space
		Jc	_not_ready
		Cmp	AX,-1			; drive letter invalid ?
		Je	_not_ready
		Cmp	CS:[Crit_Error],0	; disk error ?
		Je	Exit			; nope

_not_ready:	Mov	[ErrorLevel],1		; drive not ready

Exit:		Call	Remove_Vectors		; restore old vectors as
						; we found them

		Mov	AH,4Ch
		Mov	AL,[ErrorLevel]		; return drive ready or not
						; as ERRORLEVEL
		Int	21h			; return to DOS


;=========================================================================
; convert the character in AL to uppercase
;=========================================================================
;
Case		Proc	Near		; convert AL to upper case
		Cmp	AL,'a'
		JL	GBACK
		Cmp	AL,'z'
		JG	GBACK
		Sub	AL,20H
GBACK:		Ret
Case		Endp


;==========================================================
; get command line parameters from PSP
; the command line has the following structure,
; 80h = number of bytes in command line, excluding the <CR>
; 81h = start of command line, terminated by <CR>
;
; up to 4 command line arguments are supported and stored
; to PARM1-PARM4
;==========================================================
;
GetParms	Proc
		Push	DS
		Mov	SI,81h
		Mov	DS,ES:[PSP]
		Lea	DI,Parm1
Gmore:		Push	DI
Lmore:		Lodsb
		Cmp	AL,CR			; end of command line?
		Je	Mend			; yes, done
		Cmp	AL," "			; bypass spaces
		Je	Lmore
		Cmp	AL,TAB			; bypass TAB chars
		Je	Lmore
		Dec	SI
Lmore1:		Lodsb
		Cmp	AL,CR			; CR ?
		Je	Mend			; yes, all done
		Cmp	AL," "
		Je	Lend			; get next parm
		Cmp	AL,TAB
		Je	Lend			; get next parm
		Call	Case
		Stosb
		Jmp	Short Lmore1
Lend:		Pop	DI
		Add	DI,ParmLen
		Jmp	Short Gmore
Mend:		Pop	DI
		Pop	DS
		Ret
GetParms	Endp





;------------------------------------------------------------------------------
; install our own vector handlers
;
; MAKE SURE THAT YOU CALL INSTALL_VECTORS BEFORE YOU CALL REMOVE_VECTORS
; NOT DOING SO WILL CAUSE ERRATIC DOS BEHAVIOR GUARANTEED
;
;	This routine will replace the DOS interrupts as follows
;
;	INT 23	- ^C handler
;	INT 1B	- ^BREAK handler
;	INT 24	- critical error handler (Abort, Retry, Ignore)
;
;	It is useful to intercept these vectors so that, for example,
;	if the user were entering text and pressed ^C, your program will
;	not abort out to DOS in an unknown condition, yet your program
;	still retains the ability to check for a break condition by 
;	checking the CS:[Break_Flag] at appropriate points in your code
;	You may also check the CS:[Crit_Error] flag for critical disk errors
;	when reading files etc.
;
;	If you do want to make use of these two flags, then somewhere
;	near the beginning of your code, CALL INSTALL_VECTORS and then
;	when you exit or otherwise leave the main process, CALL REMOVE_VECTORS
;	to replace the original vectors as they arrived from DOS.
;
;	Process:
;
;	Both the ^C and ^BREAK interrupt vectors are replaced with
;	pointers to the same routine DUMMY_INT, which resides in our code
;	Whenever either of these key combinations is detected, CS:BREAK_FLAG
;	is set to a 1. All you need do is check this flag from time to time
;
;	The DOS critical error handler is replaced with a pointer to
;	our handler CRITICALERROR, which simply sets the CS:CRIT_ERROR flag
;	to a 1.
;
;-----------------------------------------------------------------------------

Install_Vectors	Proc
		Push	ES
		Mov	AX,3524h		; get critical error vector
		Int	21h			; ES:BX returns with vector
		Mov	CS:[Int24_SEG],ES	; save it for restore later
		Mov	CS:[Int24_Off],BX

; save Int 1Bh (Ctrl-Break)
		Mov	AX,351Bh
		Int	21h			; get existing vector
		Mov	CS:[Int1B_Seg],ES
		Mov	CS:[Int1B_Off],BX
		
; save Int 23h (Ctrl-C)
		Mov	AX,3523h
		Int	21h			; get existing vector
		Mov	CS:[Int23_Seg],ES
		Mov	CS:[Int23_Off],BX
		Pop	ES

; now set Int 24h vector pointing to our critical routine

		Push	DS
		Push	CS
		Pop	DS
		Mov	AX,2524h		; set function
		Mov	DX,Offset CS:CriticalError
		Int	21h

; set up Int 1Bh with pointer to IRET

		Mov	DX,Offset CS:Dummy_Int
		Mov	AX,251Bh
		Int	21h			; install ptr

; set up Int 23h with pointer to IRET

		Mov	DX,Offset CS:Dummy_Int
		Mov	AX,2523h
		Int	21h			; install ptr

		Pop	DS
		Ret
Install_Vectors	Endp


; remove IDC's error handlers from vector list and reinstall DOS vectors
;
; NOTE: MAKE SURE THAT YOU HAVE CALLED INSTALL_VECTORS BEFORE YOU
;	CALL REMOVE_VECTORS

Remove_Vectors	Proc
		Push	DS
		Mov	DS,CS:[Int24_SEG]
		Mov	DX,CS:[Int24_Off]
		Mov	AX,2524h		; set critical error vector
		Int	21h			; back to DOS's

		Mov	DS,CS:[Int23_Seg]
		Mov	DX,CS:[Int23_Off]
		Mov	AX,2523h
		Int	21h			; restore original
		
		Mov	DS,CS:[Int1B_Seg]
		Mov	DX,CS:[Int1B_Off]
		Mov	AX,251Bh
		Int	21h
		Pop	DS
		Ret
Remove_Vectors	Endp



Dummy_Int	Proc	Far
		Mov	CS:[Break_Flag],1	; flag break
		Iret
Dummy_Int	Endp


; set CritError to non-zero error code if error has occurred
; SS,SP,DS,ES,BX,CX,DX must be preserved
; user stack in force

CriticalError	Proc	Far
		Mov	CS:[Crit_Error],1	; flag the error
		Xor	AX,AX			; tell DOS to ignore error
		Iret
CriticalError	Endp


Break_Flag	DB	0	; 1 then ^C or ^BREAK has been hit
Crit_Error	DB	0	; 1 then critical error has occured
Int24_SEG	DW	0	; save old vectors here
Int24_Off	DW	0
Int1B_Seg	DW	0
Int1B_Off	DW	0
Int23_Seg	DW	0
Int23_Off	DW	0

CSEG		ENDS


DSEG		SEGMENT PARA PUBLIC 'DATA'
PSP		DW	0		; program segment prefix

Parm1		DB	64 dup(0)
Parm2		DB	64 dup(0)
Parm3		DB	64 dup(0)
Parm4		DB	64 dup(0)
ParmLen		Equ	$ - Parm4


ErrorLevel	DB	0		; 0 = drive ready, 1 = not ready
DSEG		ENDS


STACK		SEGMENT PARA STACK 'STACK'
		DW	500 DUP(0)
STACK		ENDS

		END	START
