;---------------------------------------------------------------
;iodat.inc - data for I/O Monitor                              |
;--------------------------------------------------------------|
;
iostack3        segment para stack 'STACK' use16
io_stack3       dw      256 dup('S')
io_sp3          label   word
iostack3        ends

iostack         segment para public 'STACK' use16
STACK_BEG       EQU     $
io_stack        dw      256 dup('S')
io_sp           label   word
STACK_END       EQU     $
iostack         ends

gdt_seg         segment para public 'data16' use16
                public  sel_databs
                public  sel_stack
                public  sel_video
                public  sel_data
                public  sel_tss_alias

GDT_BEG         EQU     $
sel_null        seg_descrip     <>
sel_tss         seg_descrip     <>
sel_tss_alias   seg_descrip     <>
sel_gdt_alias   seg_descrip     <>
sel_isrcode     seg_descrip     <>
sel_code        seg_descrip     <>
sel_databs      seg_descrip     <>
sel_stack       seg_descrip     <>
sel_video       seg_descrip     <>
sel_data        seg_descrip     <>
GDT_END         EQU     $
gdt_seg         ends

idt_seg         segment para public 'data16' use16
IDT_BEG         EQU     $
                DEFIDTI 0
                idt     <isrcode:int1_isr,gdt_seg:sel_isrcode,,PRESENT+(DPL0 shl 5)+INT_GATE,>
                DEFIDTI 2
                idt     <,,,PRESENT + (DPL0 shl 5) + INT_GATE,>

                irp     z, <4, 5, 6, 7>
                DEFIDTI &z
                endm

                irp     z, <8, 9, 0ah, 0bh, 0ch, 0dh, 0eh, 0fh>
                DEFIDTE &z
                endm

 idt       (1fh - 0fh)  dup(<,,,PRESENT + (DPL0 shl 5) + INT_GATE,>)

                irp     z, <20h, 21h, 22h, 23h, 24h, 25h, 26h, 27h>
                DEFIDTI &z
                endm
 idt       (6Fh - 27h)  dup(<,,,PRESENT + (DPL0 shl 5) + INT_GATE,>)

                irp     z, <70h, 71h, 72h, 73h, 74h, 75h, 76h, 77h>
                DEFIDTI &z
                endm

IDT_END         EQU     $
idt_seg         ends

data            segment para public 'data16' use16
                public  start_port
                public  end_port
                public  old_int1
                public  old_user_int
                public  io_table
                public  IO_TAB_ENTRIES
                public  access_port
                public  access_info
                public  store_buf
                public  store_buf_end
                public  store_ptr
                public  store_wrapped
                public  display_loc
                public  trap_status


DATA_BEG        EQU     $
noprot_msg      db      'Cannot run if already in protected mode.', BEEP, CR, LF, '$'
not386_msg      db      'Program requires at least an 80386.', BEEP, CR, LF, '$'
bad_2nd_msg     db      '2nd port number must be >= first port.', BEEP, CR, LF, '$'
bad_arg_msg     db      'Invalid port address specified.', BEEP, CR, LF, '$'
start_port      dw      0
end_port        dw      0
old_int1        dd      ?
old_user_int    dd      ?
access_port     dw      ?
access_info     db      ?
trap_status     db      0


io_table        io_struc        <0e4h, INPUT+CONSTANT+ABYTE>
                io_struc        <0e5h, INPUT+CONSTANT+AWORD>
                io_struc        <0e6h, OUTPUT+CONSTANT+ABYTE>
                io_struc        <0e7h, OUTPUT+CONSTANT+AWORD>
                io_struc        <0ech, INPUT+ABYTE>
                io_struc        <0edh, INPUT+AWORD>
                io_struc        <0eeh, OUTPUT+ABYTE>
                io_struc        <0efh, OUTPUT+AWORD>
IO_TAB_ENTRIES  EQU     ($ - io_table)/size io_struc


store_buf       db      BUF_SIZE dup(0)
store_buf_end   equ     $
store_ptr       dw      offset store_buf
store_wrapped   db      0


gdtl            EQU     THIS FWORD
gdtlim          dw      (GDT_END-GDT_BEG)-1
gdtadrs         dd      ?

idtl            EQU     THIS FWORD
idtlim          dw      (IDT_END-IDT_BEG)-1
idtadrs         dd      ?

display_loc     dw      0               ;offset into video page
DATA_END        EQU     $
data            ends

tss_seg         segment para public 'data16' use16
TSS_BEG         EQU     $
                tss_dat <>
TSS_END         EQU     $
tss_seg         ends
;------end of iodat.inc

