/*
ͻ
                               MESSAGE MINDER                               
                                                                            
                     By Brian Hill           March, 1992                    
                                                                            
       Message minder is a TSR program which will display a message         
  from the serial port on the screen. The message is cleared when the       
  user presses any key. The format for sending a messge is as follows:      
  1) The com port on the sending machine should be set to 9600, N, 8, 1.    
  2) A message is started with a SOH character. <alt> 1 will generate.      
  3) A message is completed with a EOT character. <alt> 4 will generate.    
                                                                            
 *NOTE when the user enters the un-install command: message u  the program  
  will only un-install properly if it is the last TSR loaded.               
                                                                            
ͼ
                                                                            */
#pragma check_stack( off )     // turn off stack checking
#pragma check_pointer( off )   // do not check for null pointers
#pragma pack(1)                // byte align data to conserve memory

#include <string.h>
#include <stdlib.h>
#include < conio.h>
#include < stdio.h>
#include <  bios.h>
#include <   dos.h>

#define SOH  1          // start of header
#define EOT  4          // end of transmit
#define ESC 27          // ASCII value of escape key
#define ENTER 13        // ASCII value for enter key
#define BACKSPACE 8     // ASCII value for backspace key
#define NORM_VID 7      // normal video attribute


/*
ͻ
             Interrupt routines and function pointers                       
ͼ
                                                                            */
void (interrupt _far *oldclock)(void);  // old clock handler
void (interrupt _far *olddosok)(void);  // old dosok handler
void (interrupt _far *oldkeybd)(void);  // old keyboard handler
void  interrupt _far keybd(void);       // our keyboard handler
void  interrupt _far clock(void);       // our clock routine
void  interrupt _far dosok(void);       // our dosok handler
void  interrupt _far serial(void);      // Our serial port ISR





/*
ͻ
           Functions our program will call when active                      
ͼ
                                                                            */
void memputs(char x,char y,char *string,char attrib); // display string
void save_screen(void);                 // save user's screen in screen[]
void restore_screen(void);              // restore user's screen
void display_message(void);             // display our message to screen
void draw_border(int type);             // make a message border
void doit(void);                        // activate TSR
void memputs(char x, char y,char *string, char attrib);
void send_message(void);                // Get message and transmit
void display_message(void);             // show received message
void xmit_char(char ch);                // sent a character out COM 1
int  chk_xmit(void);                    // Is it OK to send a character?
int  mem_gets(char *szStr,int xyStrRow, int xyStrCol);  // get a string
void write_char(int x,int y,char ch,char attrib);       // write char at x,y
void goto_xy(int x, int y);                             // move cursor
void get_xy(int *x, int *y);            // get cursor pos -w- BIOS
void beep(void);                        // short "beep" thru PC's speaker

void main();
void init(void);                        // set up program
int  check_install(int num);            // check if program resident
void interrupt _far un_install (void);  // pointer to un-install function

/*
ͻ
                            Program data                                    
ͼ
                                                                            */
char buffer[81];                        // our serial input buffer
char userscreen[481];                   // save user's screen here
int  port;                              // com1 port address
int  _far *keyboard_status;             // check if <ctrl> is pressed.
char _far *video = (char far *)0xB8000000;   // pointer to color video memory
char _far *mode  = (char far *)0x00400049;   // pointer to CRT video mode

char _huge *tsrstack;                   // our stack space
char _huge *tsrbottom;                  // huge pointer to our PSP
char _huge *userstack;                  // user's stack space

char string[] = {"_MESSAGE"};           // TSR signature
struct tsrinfo
{
     char *signature;                   // pointer to TSR signature
     void (interrupt _far *un_install_ptr)(void);   // pointer to un-install

} transient, _huge *resident;




/*
ͻ
                             Flags                                          
ͼ
                                                                            */
char _far request_to_run;               // Has message arrived?
char _far tsr_running;                  // Is menu displayed?
_segment(dosseg);                       //  Segment of inDos flag.
char _based(dosseg) *indos;             //  Based pointer to InDos flag.
char video_mode_flag;                   // Waiting for appropriate video mode?


/*
ͻ
                               Code                                         
ͼ
                                                                            */
void main(int argc, char **argv)
{

 unsigned tsrsize;               // memory needed for residence
 int i;                          // a scratch pad variable
 char ch;

/*
    ͻ
                        Claculate program size                           
    ͼ
                                                                           */
 _asm mov WORD PTR tsrstack[0], sp              // save our stack address
 _asm mov WORD PTR tsrstack[2], ss
 FP_SEG(tsrbottom) = _psp;                      // save PSP address
 FP_OFF(tsrbottom) = 0;
 tsrsize = ((tsrstack - tsrbottom) >> 4) + 1;   // calculate program size

/*
    ͻ
                       Is the program already installed?                 
    ͼ
                                                                            */

 transient.un_install_ptr = un_install; // establish pointer to un_install
 transient.signature = (char *) string; //set pointer in structure to signatre
 resident = (struct tsrinfo _huge *)&transient;// establish pointer to struct

 if( (argc == 2) && (*argv[1] == 'u') )        // uninstall?
 {
     if(check_install(1))
        printf("\n\nProgram Un-installed.");

     else printf("\n\nProgram was not resident.");
     exit(1);
 }

 else if(check_install(0))                       // Already resident?
 {
     printf("\n\nProgram already installed.");
     exit(1);
 }


 printf("\n\nMESSAGE is resident.");
 printf("\nPress <ctrl> w to send a message.");
 printf("\nBrian Hill 03/25/92\n");
 init();                         // set up vectors.
 _dos_keep(0,tsrsize);           // terminate but stay resident; exit code 0

} // end of main()

/*
ͻ
                          Setup program.                                    
ͼ
                                                                            */
void init(void)
{
 char ch;                        // scratch pad
 int far *p;                     //

/*
      ͻ
                      Set up serial port parameters.                  
      ͼ
                                                                           */
 p = (int far *) 0x00400000;     // pointer to DOS port info
 port = *p;                      // get port address for COM 1

 ch = inp(port + 3);             // get control register info

 /* port value for 8, N, 1 = xx 000 0 11 */
 ch &= 0xC0;                     // save two high bits (xx)
 ch |= 0x03;                     // specify 8 data bits
 outp(port + 3, ch);             // set 8N1

 /* Set BPS rate to 9600 :: 115,200 / 12 = 9,600 BPS  */
 outp(port + 3, ch | 0x80);      // raise Data Latch Access Bit
 outp(port    , 12);             // write low  byte
 outp(port + 1, 0x00);           // write high byte

 ch = inp(port + 3);             // lower DLAB
 outp(port + 3, ch & 0x7F);







/*
       ͻ
                             Set up interrupts.                     
       ͼ
                                                                            */
 oldclock = _dos_getvect(0x1C);    // save old clock vector
 olddosok = _dos_getvect(0x28);    // save old indos vector
 oldkeybd = _dos_getvect(0x09);    // save old keybd vector

 _disable();                       // establish our routines
 _dos_setvect(0x1C, clock);        // replace timer tick
 _dos_setvect(0x28, dosok);        // replace dosok interrupt
 _dos_setvect(0x09, keybd);        // replace keybd interrupt
 _dos_setvect(0x0C, serial);       // replace COM 1 interrupt

 _enable();

/*
       ͻ
                        Enable serial port interrupt.                  
       ͼ
                                                                            */
 ch = inp(0x21);         // read 8259 interrupt mask
 outp(0x21,ch & 0xEF);   // set mask to enable COM 1

 ch = inp(port+1);       // read interrupt enable register
 ch &=1;
 outp(port+1,ch|1);      // enable interrupt for recieve char
 for(ch=0;ch<6;ch++) inp(port+ch); // read to ports to clear them
 ch = inp(port+4);       // read control register
 ch &=8;
 outp(port+4,ch|8);      // set GOUT2 to enable interrupt


/*
       ͻ
                         Get address of InDOS flag                     
       ͼ
                                                                            */
 _asm
 {
  mov ah, 34h             //  DOS service, get pointer to
  int 21h                 // indos flag.
  mov dosseg, es          //  Initialize based pointer to
  mov indos,  bx          // flag -- ES:BX.
 }

 /* use this pointer to see if <ctrl> key is pressed. */
 keyboard_status = (int _far *)0x00400017;

}// end of install()



/*
ͻ
                      Our program's clock handler                          
ͼ
                                                                           */
void  interrupt far clock(void)
{

 outp(0x20,0x20);                // clear 8259
 (*oldclock)();                  // chain to old handler

 if(request_to_run && !tsr_running)      // request for activation?
 {
  if(*indos == 0)                        // is a DOS call in operation?
  {
    if( (*mode == 2) || (*mode == 3) )   // in 80 column color text mode?
    {
      video_mode_flag = 0;          // we are in an appropriate video mode

      if(request_to_run == 2)       // Has user pressed hotkey?
             tsr_running = 2;       //  then send a message.
      else tsr_running = 1;         // else message received.
      request_to_run = 0;           // we are active, kill request to activate
      doit();                       // become visible
      tsr_running = 0;              // no longer running
    }
    else                            // wait for proper video mode
    {
      if(video_mode_flag == 0)
      {
        video_mode_flag = 1;        // set flag -- we have beeped once.
        beep();                     // alert user by beeping once
      }
    } // end of if improper video mode

  }   // end of indos check
 }    // end of request to run

}     // end of clock handler















/*
 ͻ
                          Our DOSOK handler                                
 ͼ
                                                                           */
void  interrupt far dosok(void)     // DOS performing console I/O?
{

 if(request_to_run && !tsr_running)      // request for activation?
 {
   if( (*mode == 2) || (*mode == 3) )
   {
      video_mode_flag = 0;          // we are in an appropriate video mode.

      if(request_to_run == 2)       // Has user pressed hotkey?
             tsr_running = 2;       //  then send a message.
      else tsr_running = 1;         // else message received.
      request_to_run = 0;           // we are active, kill request to activate
      doit();                       // become visible.
      tsr_running = 0;              // no longer running.

   }
   else                             // wait for proper video mode
   {
      if(video_mode_flag == 0)
      {
        video_mode_flag = 1;        // set flag -- we have beeped once.
        beep();                     // alert user by beeping once
      }
   }  // end of if improper video mode

 }    // end of if request to activate TSR

 (*olddosok)();                          // chain to old handler
}     // end of dosok handler



















/*
ͻ
                        Our keyboard handler                               
ͼ
                                                                           */
void interrupt _far keybd(void)
{
       char ch;

       if(                                      // hotkey combo pressed?
             ( (ch = inp(0x60)) == 0x11) &&     // Check for w key
             !tsr_running &&                    // Already active?
             (*keyboard_status & 4)             // Shift key down?
         )
       {                                        // yes, get input.
           outp(0x20,0x20);                     // clear 8259
           request_to_run = 2;
           return;
       }
       (*oldkeybd)();
} // end of keybd()


/*
 ͻ
                       Our serial port handler                             
 ͼ
                                                                           */
void  interrupt _far serial(void)        // Our serial port ISR
{
 char ch;
 static char message_flag;       // message in progress?
 static int current_array;       // position in buffer

 ch = inp(port);                 // get character
 outp(0x20,0x20);                // clear 8259 interrupt

 if(message_flag)                // are we receiving a message?
  {
  if(ch == EOT)                  // End Of Transmit: full message recieved.
    {
      buffer[current_array] = 0x00;  // NULL end to make a string
      current_array = 0;          // start new buffer
      message_flag = 0;           // new message
      request_to_run = 1;         // ask to display message
    }
  else                            // add next character to buffer
    {
      buffer[current_array++] = ch;
      if(current_array > 80)  current_array = 0;
    }
  } // end of if message_flag
 else  if(ch == SOH) message_flag = 1;   // Start Of Header: new message.
} // end of serial handler
/*
ͻ
                      Become active foreground process                      
ͼ
                                                                            */
void doit(void)              // become active foreground process
{
 _disable();                            // disable interrupts
 _asm MOV WORD PTR userstack[0], sp     // save user's stack
 _asm MOV WORD PTR userstack[2], ss
 _asm MOV sp, WORD PTR tsrstack[0]      // set up local stack
 _asm MOV ss, WORD PTR tsrstack[2]
 _enable();                             // enable all interrupts

 beep();                                // short "beep" thru PC speaker
 if(tsr_running == 2) send_message();   // popup window, send_screen
 else display_message();                // save screen, display window

 _disable();                            // disable interrupts
 _asm MOV sp, WORD PTR userstack[0]     // restore user's stack
 _asm MOV ss, WORD PTR userstack[2]
 _enable();                             // enable all interrupts
} // end of display_message

/*
 ͻ
                  Get message from user and set theu COM 1                 
 ͼ
                                                                           */
void send_message(void)
{
 char string[81];               // string to send
 char *p;
 int x, y;                      // user's cursor position saved here

 get_xy(&x,&y);                 // save user's cursor position
 string[0] = 0;                 // null to ensure it is a string.
 save_screen();                 // save user's screen
 draw_border(1);                // create border for our window
 if( mem_gets(string,1,1)== -1) return;  // Get string at 1,1. ESC key hit?

 /* send string thru COM 1 */
 p = string;
 xmit_char(SOH);           // start transmission
 while(*p)
 {
      xmit_char(*p);       // sent this character
      p++;                 // next character
 }
 xmit_char(EOT);           // end transmission

 restore_screen();         // fix user's screen
 goto_xy(y,x);             // restore user's cursor position
}
/*
ͻ
                   Display received message in a window                    
ͼ
                                                                           */
void display_message(void)
{
 save_screen();                // save user's screen
 draw_border(0);               // create message border.
 memputs(1,1,buffer,7);        // display message string
 while(_bios_keybrd(_KEYBRD_READY))  {;}   // wait for key
 _bios_keybrd(_KEYBRD_READ);
 restore_screen();             // restore user's screen
}


/*
ͻ
                        Save user's screen.                                 
ͼ
                                                                            */
void save_screen()
{
 int num;

 for(num=0;num<=480;num++)                  // save top three lines of screen
    userscreen[num] = *(video + num);

}  // end of save_screen

/*
ͻ
                         Restore user's screen.                             
ͼ
                                                                            */
void restore_screen()
{
 int num;

 for(num=0;num<=480;num++)                     // restore top three lines
  *(video + num) = userscreen[num];

}  // end of restore screen











/*
ͻ
            Display string at x,y with direct screen write.                 
ͼ
                                                                            */
void memputs(char x, char y,char *string, char attrib)
{
 char _far *p;                      // pointer to video ram

 p = video;
 p += (y*160) + x*2;                // addres of col,row

 while(*string)
 {
  *p++ = *(string++);               // character
  *p++ = attrib;                    // attribute
 }
}  // end of memputs

/*
ͻ
                    Draw border for our window.                             
ͼ
                                                                            */
void draw_border(int type)
{
 char string[81];               // string used to hold lines of border
 int length;                    // length of string to fit inside border
 int x;

 if(!type)                      // make border a full line?
 {
    length = strlen(buffer);    //    No.
    length++;
 }
 else length = 79;              //    Yes.

 for(x = 1; x < length; x++)       // top line
   string[x] = 205;
 string[0] = 201;                  // upper left corner
 string[length] = 187;             // upper right cornet
 string[length + 1] = 0;           // end string;
 memputs(0,0,string,7);            // display top line

 string[0] = 200;                  // lower left corner
 string[length] = 188;             // lower right corner
 memputs(0,2,string,7);            // display bottom line

 for(x = 1;x < length; x++)
   string[x] = ' ';                // empty string
 string[0] = 186;                  // left side
 string[length] = 186;             // right side
 memputs(0,1,string,7);            // display sides
} // end of draw_border
/*
  ͻ
     Read in string from keyboard, displaying with direct screen writes.  
  ͼ
                                                                           */
int mem_gets(char *szStr,int xyStrRow, int xyStrCol)
{
        int xyCurX;         // cursor col
        int xyCurY;         // cursor row
        int cbStrLen = 0;   // length of string
        char chKey;         // scan code

        xyCurX = xyStrCol;  // start at specified cursor position
        xyCurY = xyStrRow;
        goto_xy(xyCurY, xyCurX);            //  Keep cursor with us.

        while(1)
        {
             while(_bios_keybrd(_KEYBRD_READY))  {;}   // wait for key
             chKey = _bios_keybrd(_KEYBRD_READ);

             switch(chKey)
             {
                case (ENTER):
                      szStr[cbStrLen] = 0;      // end string
                      return(0);
                      break;
                case (BACKSPACE):
                      if(xyCurX > xyStrCol)
                      {
                         xyCurX--;                      // cursor to left
                         szStr[--cbStrLen] = ' ';       // erase character
                         write_char(xyCurY, xyCurX,' ',NORM_VID);
                         goto_xy(xyCurY,xyCurX);        // set cursor pos
                         continue;
                      }
                      break;
                case ESC:
                      szStr[cbStrLen] = 0;   // null string
                      return -1;
                      break;
                default:
                    /*string too big to fit on screen? */
                    if( xyCurX < (xyStrCol + 77) )
                    {
                       write_char(xyCurY, xyCurX,chKey,NORM_VID);
                       xyCurX++;                  // increment cursor position
                       szStr[cbStrLen++] = chKey; // store char in string
                       goto_xy(xyCurY,xyCurX);    // move cursor over
                    }
                    break;
             } // end of switch
        } // end of while
} // end of mem_gets
/*
ͻ
              Write character with specified attribute                      
ͼ
                                                                            */
void write_char(int x,int y,char ch,char attrib)
{
  register int i;
  char _far *v;

  v = video;
  v += (x*160) + y*2; /* compute the address */
  *v++ = ch;  /* write the character */
  *v = attrib;    /* write the attribute */
}

/*
ͻ
                         Get cursor pos -w- BIOS                            
ͼ
                                                                            */
void get_xy(int *x, int *y)
{
        int row, col;
        _asm
        {
            mov ah, 03          // bois service 3, get cursor position
            mov bh, 00          // video page 0
            int 10h             // invoke video service
            mov row, dh         // save row anf column
            mov col, dl
        }
        *x = col;
        *y = row;
}


/*
ͻ
                           Send cursor to x,y                               
ͼ
                                                                            */
void goto_xy(int x,int y)
{
  union REGS r;

  r.h.ah=2; /* cursor addressing function */
  r.h.dl=y; /* column coordinate */
  r.h.dh=x; /* row coordinate */
  r.h.bh=0; /* video page */
  int86(0x10, &r, &r);
}


/*
 ͻ
     Check for program residency and un-install if requested.              
 ͼ
                                                                           */
/*
     This function will return a 1 if the TSR's signature is found, or a
   0 if it is not. Passing this function a non-zero value will rresult
   in un-installing the resident TSR, if it is found.
*/
int check_install(int num)
{
        _segment(seg);               // segment of a pointer
        int _based(seg) *psp_check;  // based pointer to a PSP
        struct tsrinfo _based(seg) *string_check; // pointer to tsrinfo
        unsigned loop;

        /* find offset for tsrinfo structure */
        string_check = (struct tsrinfo _based(seg) *)
                       ((char _huge *)resident - tsrbottom);

        seg = 0;
        psp_check = 0;


        /* check every segment of memory to see if it is a PSP */
        for(loop = 0; loop < 0xFFFF;loop++)
        {
                if(seg == _psp) continue;   // skip our own transient PSP

                if(*psp_check == 0x20CD)    // found a PSP?
                {
                        /* see if TSR signature present. */
                        if (
                            (string_check->signature[0] == '_') &&
                            (string_check->signature[1] == 'M') &&
                            (string_check->signature[2] == 'E') &&
                            (string_check->signature[3] == 'S') &&
                            (string_check->signature[4] == 'S') &&
                            (string_check->signature[5] == 'A') &&
                            (string_check->signature[6] == 'G') &&
                            (string_check->signature[7] == 'E')
                           )
                        {
                            /* un-install program, if requested. */
                            if(num)(string_check->un_install_ptr)();

                            return 1;   // resident program found
                        } // end of if signature found
                } // end of if psp
                seg++;    // next segment
        } // end of memory search loop
        return 0;         // resident program not found
}
/*
ͻ
                  Wait until serial port available                          
ͼ
                                                                            */
int chk_xmit()                  // wait 'til port available
{
        int status;

        status = inp(port + 5); // read line status register
        return(status & 0x20);  // = xx1xxxxx binary when OK to send character
}


/*
ͻ
                      transmit char ch out COM 1                            
ͼ
                                                                            */
void xmit_char(char ch)
{
        while(chk_xmit() == 0) {;}  // wait until port available
        outp(port,ch);              //  and then send it out
}


/*
   ͻ
                      Produce a short "beep"                              
   ͼ
                                                                         */
void beep(void) // short speaker beep
{
        unsigned long _far *tick;
        unsigned long start_time;
        char ch;

        /* point to system time */
        tick = (unsigned long _far *)0x0040006C;

        _enable();              // enable interrupts

        ch = inp(0x61);
        outp(0x61, ch | 3);     // turn speaker on
        start_time = *tick;
        while( (*tick - start_time) < 3) { ; }  // short pause...
        outp(0x61, ch);         // turn speaker off
}






/*
  ͻ
          Check for program residency; un-install if requested.             
  ͼ
                                                                            */
/*
    This function is declared with the interrupt key word because it is not
  part of the program that calles it - the transient version of "Message".
  It is in the RESIDENT version of "Message".
*/

void interrupt _far un_install(void)
{
 char ch;
 _segment(pspvariable);
 unsigned int _based(pspvariable) *environ;

 /*
     Disable serial port interrupt by setting the General Purpose Out 2
   on the UART. This will prevent any interrupt generated by an incomeing
   character to reach the PC's interrupt controller

 */
 ch = inp(port+4);       // read control register
 ch &=8;
 outp(port+4,ch^8);      // set GPOUT2 to disable interrupt

 transient.signature[0] = 0;     // erase signature
 _disable();                     // restore vectors
 _dos_setvect(0x09,oldkeybd);
 _dos_setvect(0x1C,oldclock);
 _dos_setvect(0x28,olddosok);
 _enable();

 pspvariable = _psp;
 environ = (int _based(pspvariable) *)0x2C;
 _dos_freemem(*environ);     // free environment memory
 _dos_freemem(_psp);         // free program memory
}