/*
    SlikMode - sets a serial port to any bps rate.


    Copyright 1989 Software For Cash, Inc.

    Brian Henning
*/

#include	<bios.h>
#include	<stdio.h>
#include	<stdlib.h>

#define	BRDL 0				/* offset for baud rate divisor - lo	*/
#define	BRDH 1				/* offset for baud rate divisor - hi	*/
#define	IER	1				/* offset for interrupt enable register */
#define LCR 3               /* offset for line control register     */

char *p = "Even";           /* printable interpretation of parity   */

int	main(int argc, char *argv[])
{
	int	i = 0,				/* general purpose integer variable	*/
		s = 1,				/* default stop bits				*/
		d = 7,				/* default data bits				*/
		n = 1;				/* default COM port number			*/

	unsigned
        data   = 0x02,           /* 7 bit data default  */
        stop   = 0x00,           /* 1 stop bit default  */
        parity = 0x30,           /* even parity default */
		brdl   = 0x60,
        brdh   = 0x00,          /* means 1200 baud is the default      */
        lcr   = 0x00,           /* will contain stop,data,parity flags */
		base[4]= {0x03f8,
				0x02f8,
				0x03e8,
                0x02e8},        /* base port for COM 1, 2, 3, and 4 */
        baud   = 1200;          /* default baud rate                */

	long baud_rate = 0L;		/* calculated baud rate				*/

	union
		{
        unsigned u;         /* 16 bits worth of flags, etc. */
		struct
			{
            unsigned diskflag   :1; /* diskette drive installed      */
            unsigned coproc     :1; /* coprocessor                   */
            unsigned sysram     :2; /* RAM on system board           */
            unsigned video      :2; /* startup video mode            */
            unsigned disks      :2; /* drives 00=1, 01=2, 10=3, 11=4 */
            unsigned dma        :1; /* 0=Yes, 1=No (1 for PC Jr.)    */
            unsigned comports   :3; /* number of serial ports        */
            unsigned game       :1; /* game adapter installed        */
            unsigned modem      :1; /* internal modem                */
            unsigned printers   :2; /* number of printers            */
			} bits;
		} equip;

/***************************************************************************/
/* if no operands, then show the help text and exit                        */
/***************************************************************************/

	if (argc < 2)
		{
		printf("\nSLIKMODE - Copyright 1989 Software For Cash, Inc.\n\n");
		printf("Parameters:\n");
		printf("\t/bn - BAUD RATE where n is a baud rate of your choice\n");
		printf("\t/cn - COM  PORT where n is 1,2,3, or 4, if installed\n");
		printf("\t/dn - DATA BITS where n is 7 or 8\n");
		printf("\t/px - PARITY    where x is E, O, or N for EVEN, ODD, or NONE\n");
		printf("\t/sn - STOP BITS where n is 1 or 2\n\n");
		printf("\tDefaults are COM1:1200,E,7,1\n");
		exit(0);
		}

/***************************************************************************/
/* eat all of the passed parms in order, building up the data word as req'd*/
/***************************************************************************/

	for (i=1;i<argc;i++)
		{
        if (strnicmp("/d",argv[i],2) == 0)    /* data bits */
			{
			if (*(argv[i]+2) == '7')
				{
				data = 0x02;
				d = 7;
				continue;
				}

			if (*(argv[i]+2) == '8')
				{
				data = 0x03;
				d = 8;
				continue;
				}
			printf("\aNumber of data bits (/d) is not 7 or 8\n");
			exit(1);
			}

        if (strnicmp("/s",argv[i],2) == 0)    /* stop bits */
			{
			if (*(argv[i]+2) == '1')
				{
				stop = 0x00;
				s = 1;
				continue;
				}

			if (*(argv[i]+2) == '2')
				{
				stop = 0x04;
				s = 2;
				continue;
				}

			printf("\aNumber of stop bits (/s) is not 1 or 2\n");
			exit(1);
			}

        if (strnicmp("/p",argv[i],2) == 0)    /* parity */
			{
			if ((*(argv[i]+2) | '\x20') == 'n')
				{
				parity = 0x00;
				p = "None";
				continue;
				}

			if ((*(argv[i]+2) | '\x20') == 'e')
				{
				parity = 0x30;
				p = "Even";
				continue;
				}

			if ((*(argv[i]+2) | '\x20') == 'o')
				{
				parity = 0x20;
				p = "Odd";
				continue;
				}

			printf("\aParity (/p) is not EVEN, ODD, or NONE\n");
			exit(1);
			}

        if (strnicmp("/b",argv[i],2) == 0)    /* baud rate */
			{
			if (baud = atoi(argv[i]+2))
				{
				baud_rate = (1843200L/(long)(baud*16L));

				brdl = baud_rate % 0x0100;
				brdh = baud_rate / 0x0100;

				continue;
				}

			printf("\aBaud rate (/b) cannot be zero\n");
			exit(1);
			}


        if (strnicmp("/c",argv[i],2) == 0)    /* comm port */
			{
			equip.u = _bios_equiplist();

			n = atoi(argv[i]+2);

			if ((n < 1) || (n > equip.bits.comports))
				{
				printf("\aCOM port (/c) value invalid\n");
				exit(1);
				}
			n--; 	/* make port index relative to zero	*/
			}

		else
			{
			printf("\aUnknown parmameter %s\n",argv[i]);
			exit(1);
			}
		}

/* request to diddle the baud rate divisor registers by setting LCR to 0x80	*/

	outp(base[n]+LCR,0x80);


/* stuff the requested values into the baud rate divisor registers */

	outp(base[n]+BRDH,brdh);
	outp(base[n]+BRDL,brdl);


/* stuff settings for data, stop, and parity bits into the LCR,
   and enable the transmitter hold and data receiving registers */

	outp(base[n]+LCR,( (data | stop | parity) & 0x007f) );


/* enable the UART for interrupts */

	outp(base[n]+IER,0x00);


/* now brag about what we did */

    printf("SlikMode - COM%d:%d,%s,%d,%d\n",n+1,baud,p,d,s);

	exit(0);
}
