	title	Toad8253
;
;Author: David Kirschbaum 31 Aug 88
;From "DMA Control on the PC"
;by Larry Fogg, Micro Cornucopia #37, Sep-Oct 87
;
;The article suggests a way to tweak the 8253 timer to slow down the RAM
;refresh rate.  Author suggests you can slow the normal DREQ0 interrupt
;from its normal 15-microsecond interval to up to a full second before RAM
;will start failing.
;
;Extract from the article's text:
;     "It was right at one refresh every second that my RAM faded away.
;A count of 900H loaded into the 8253's Timer 1 gives the one second
;period.
;     "The BIOS loads the count with 12H and the point of diminishing returns
;comes around 30H or 40H.  After 40H refresh happens so infrequently as to
;have no effect on system performance.  Benchmarks show no difference between
;40H and 900H.
;     "A value of 40H gives a 2.6% speed increase on my Holliston 186 board
;and a 5.8% increase on a standard 4.77 MHz 8088.  I haven't had any problems
;using this speedup.  But don't blame me if your machine dissolves into a
;puddle of blue slime.  After all, we've gone beyond the limits of computer
;decency."
;
;Toad Hall Notes:
;The author provided some assembler code to be used via DEBUG.
;I rewrote it into a proper MASM-compatible .ASM format so you can compile
;to REFRESH.COM (or whatever you wanna name it).  Run it on startup.
;Returns the LSB as the DOS ERRORLEVEL (for what that's worth).
;
;Sure, I could write this to take the LSB from the DOS command line,
;but that would only be for experimental use.  Better for you to determine
;the "magic number" that's best for your system and just leave it hard-
;coded.  That way no user will accidentally enter some weird number!
;
;I used the public domain MIPS.COM v1.10 CPU speed utility as a benchmark.
;I also ran Norton's SYSINFO.COM (SI) utility just for comparisons.
;The SI values vary irregularly on sequential runs (e.g., the 40H lsb
;value produced SI ratings of 7.0 to 7.1).

;Following are MIPS and SI results after running TOAD8253 with various
;LSB values (and in the most extreme, a new MSB value).
;
;					Counter 1 values
;			12H	40H	80H	0A0H	0100H
;General Instructions	0.48	0.50	0.51	0.51	0.51
;Integer Instructions	0.87	0.90	0.90	0.91	0.91
;Memory to Memory	0.69	0.74	0.75	0.76	0.76
;Register to Register	1.13	1.14	1.15	1.15	1.15
;Register to Memory	0.89	0.94	0.96	0.96	0.96
;Performance Rating	0.81	0.85	0.85	0.86	0.86
;Norton's SI rating	7.0	7.1	7.1	7.1	7.1
;
;So, no significant changes after bumping the lsb to 0A0H or beyond.
;(No, I did NOT push the timer to RAM memory failure!)
;
;Now, if you want to slow your system DOWN (not the original intention,
;but some users need to slow down fast clones for games, etc.), here are
;some slowdown stats:
;
;					Counter 1 values
;			10H	0AH	07H	05H	03H	02H	01H
;General Instructions	0.47	0.44	0.39	0.38	0.26	0.23	LOCKUP!
;Integer Instructions	0.87	0.84	0.83	0.77	0.63	0.57
;Memory to Memory	0.68	0.63	0.59	0.54	0.33	0.35
;Register to Register	1.11	1.09	1.01	1.01	0.81	0.81
;Register to Memory	0.87	0.81	0.75	0.66	0.47	0.50
;Performance Rating	0.80	0.76	0.71	0.67	0.50	0.49
;Norton's SI rating:	6.6	6.6	6.3	6.2	4.4	4.6
;
;My system is an older GulfStream 8MHz 80286 (XT-compatible, Phoenix ROM)
;running PC-DOS 3.1.  Your mileage may vary.
;
;David Kirschbaum
;Toad Hall
;kirsch@braggvax.ARPA

CodeSeg	SEGMENT PUBLIC PARA 'Code'
	ASSUME	CS:CodeSeg, DS:CodeSeg, ES:CodeSeg

VALUE	EQU	00A0H		;TH optimum value, LSB=0AH, MSB=0

	org	100H

Toad8253	proc	near
	mov	al,74H		;configure 8253 (see Micro C #35, p.30)
	out	43H,al
	mov	ax,VALUE
	out	41H,al		;change counter 1 lsb to alter refresh rate
	xchg	al,ah		;msb for counter 1
	out	41H,al
	xchg	al,ah		;lsb back in AL as ERRORLEVEL
	mov	ah,4CH		;DOS terminate process
	int	21H

Toad8253	endp
CodeSeg	ends
	end	Toad8253
