#ifndef ITRANS_MAP_H
#define ITRANS_MAP_H

/*
 *========================================================================== 
 * Copyright 1991 Avinash Chopde, All Rights Reserved.
 *
 * Permission to use, copy, modify and distribute this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Avinash Chopde not be used in
 * advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.
 * Avinash Chopde makes no representations about the suitability of this
 * software for any purpose.
 * It is provided "as is" without express or implied warranty.
 *
 * AVINASH CHOPDE DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
 * IN NO EVENT SHALL AVINASH CHOPDE BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THIS SOFTWARE.
 *
 * Author:  Avinash Chopde, 1991
 *	    C2 Colonial Drive #4, Andover, MA 01810, USA.
 *
 */

/* static char S_RCSID[] = "$Header: e:/itrans/src/rcs/imap.h 1.3 91/09/26 22:59:01 avinash Exp $"; */

#ifndef MSDOS
#include "y.tab.h"
#else
#include "y_tab.h"
#endif

#define	CNAMELEN	16
	/* max length of the code name of any indian char */

typedef struct {
    int		token; /* char token - assigned by y.tab.h */
    char	codename[CNAMELEN+1]; /* name assigned to it in ifm file */
} ifm_enc_t;

/* Some arbit representation of input token names, this is pretty
 * much free-form - no duplicate names allowed.
 * Used to parse the Devn Metrics file - see font.c
 * XXX
 * Will presumably be used later, to make error messages a bit
 * descriptive as to what actually expected...

 * Note:  names should be letters only (case is not ignored)
 *        do not use "-" in the names.
 * Any changes here implies that the file font.c needs to be edited:
 * the struct S_ifm_map has to be filled in accordingly.
 */

#define A_CNAME		"a"
#define AA_CNAME	"aa"
#define I_CNAME		"i"
#define II_CNAME	"ii"
#define U_CNAME		"u"
#define UU_CNAME	"uu"
#define RI_CNAME	"ri"
#define RII_CNAME	"rii"
#define LI_CNAME	"li"
#define LII_CNAME	"lii"
#define AY_CNAME	"ay"
#define AAY_CNAME	"aay"
#define AI_CNAME	"ai"
#define O_CNAME		"o"
#define OO_CNAME	"oo"
#define AU_CNAME	"au"
#define AM_CNAME	"am"
#define AHA_CNAME	"aha"
#define KA_CNAME	"ka"
#define KADOT_CNAME	"kadot"
#define KHA_CNAME	"kha"
#define KHADOT_CNAME	"khadot"
#define GA_CNAME	"ga"
#define GADOT_CNAME	"gadot"
#define GHA_CNAME	"gha"
#define NGA_CNAME	"nga"
#define CHA_CNAME	"cha"
#define CHHA_CNAME	"chha"
#define JA_CNAME	"ja"
#define JADOT_CNAME	"jadot"
#define JHA_CNAME	"jha"
#define JNH_CNAME	"jnh"
#define TTA_CNAME	"tta"
#define TTHA_CNAME	"ttha"
#define DDA_CNAME	"dda"
#define DDADOT_CNAME	"ddadot"
#define DDHA_CNAME	"ddha"
#define DDHADOT_CNAME	"ddhadot"
#define NNA_CNAME	"nna"
#define TA_CNAME	"ta"
#define THA_CNAME	"tha"
#define DA_CNAME	"da"
#define DHA_CNAME	"dha"
#define NA_CNAME	"na"
#define PA_CNAME	"pa"
#define PHA_CNAME	"pha"
#define PHADOT_CNAME	"phadot"
#define BA_CNAME	"ba"
#define BHA_CNAME	"bha"
#define MA_CNAME	"ma"
#define YA_CNAME	"ya"
#define RA_CNAME	"ra"
#define LA_CNAME	"la"
#define VA_CNAME	"va"
#define SHA_CNAME	"sha"
#define SHHA_CNAME	"shha"
#define SA_CNAME	"sa"
#define HA_CNAME	"ha"
#define LDA_CNAME	"lda"
#define KSHA_CNAME	"ksha"
#define GYA_CNAME	"gya"
#define NYA_CNAME	"nya"
#define NNX_CNAME	"nnx"
#define RRA_CNAME	"rra"

#define RA_HALF_CNAME	"rahalf"
#define ANUSVARA_CNAME	"anusvara"
#define CHANDRA_CNAME	"chandra"
#define CHANDRA_BN_CNAME	"chandrabindu"
#define VIRAAM_CNAME	"viraam"
#define AVAGRAHA_CNAME	"avagraha"
#define SRI_CNAME	"sri"
#define AUM_CNAME	"aum"

/* num indian lang characters */
/* see font.c also */
#define FIRSTCHAR	_I_(A_TOK)
#define LASTCHAR	_I_(AUM_TOK)
#define	NUMCHARS	(LASTCHAR-FIRSTCHAR+1)
#define FIRSTVOW	_I_(A_TOK)
#define LASTVOW		_I_(AHA_TOK)
#define FIRSTCONS	_I_(KA_TOK)
#define LASTCONS	_I_(PHADOT_TOK)
#define NUMEXTRA	10
#define	NUMKHADI	(NUMCHARS+NUMEXTRA)
	/* allow for extra chars that the user may define */
#define	OFFSET_TOK	(DUMMY_TOK+1)

/* num postscript chars - 8 bits = 0 to 255 */
#define	NUMPSCHARS	256

#endif /* ITRANS_MAP_H */
