#ifndef ITRANS_H
#define ITRANS_H

/*
 *========================================================================== 
 * Copyright 1991 Avinash Chopde, All Rights Reserved.
 *
 * Permission to use, copy, modify and distribute this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Avinash Chopde not be used in
 * advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.
 * Avinash Chopde makes no representations about the suitability of this
 * software for any purpose.
 * It is provided "as is" without express or implied warranty.
 *
 * AVINASH CHOPDE DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
 * IN NO EVENT SHALL AVINASH CHOPDE BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THIS SOFTWARE.
 *
 * Author:  Avinash Chopde, 1991
 *	    C2 Colonial Drive #4, Andover, MA 01810, USA.
 *
 */

/* static char S_RCSID[] = "$Header: e:/itrans/src/rcs/itrans.h 1.10 91/11/28 20:38:42 avinash Exp $"; */

#include <stdio.h>
#include "../version.h"

#if defined(MSDOS) || defined(sgi)
/* actually, should be included in more places, but many systems
 * are still missing this file...
 */
#include "stdlib.h"
#endif

#ifdef SYSV
#include <string.h>
#else
#include <strings.h>
#endif

#ifdef sgi
#include <malloc.h>
#endif

#if defined(__STDC__) || (PROTO_C)
#   define P(s)	s
#else
#   define P(s) ()
#endif

#include <ctype.h>
#define YYDEBUG 1

#include "imap.h"

#ifdef MSDOS

# define PATHSEP	';'
# define DIRSEP		'\\'
# define PATH_MAX	256

#else

# include <pwd.h>
# define PATHSEP	':'
# define DIRSEP		'/'
# define PATH_MAX	1024

#endif

/* CONVWORD_LEN is the number of characters that will be generated
 * (in TeX or in PostScript) when a single input word is converted
 * Should be large enough to handle the verbose TeX commands,
 * long words in indian languages....
 */
#define CONVWORD_LEN	8192

/* somewhere between Jan-July 1991, the first version of this
 * software came out.
 * Supported Devnagari only, under hindi/marathi switches.
 */

/* environment variable for all the paths to search for input file.. */
#define ITRANS_PATH	"ITRANSPATH"
#ifdef MSDOS
#define ITRANS_PATH_DEF	"ITRANSPATH=;..\\lib;"
#else
#define ITRANS_PATH_DEF	"ITRANSPATH=:../lib:"
#endif

/* the default ifm file to use --- assume devanagari input */
#define DEVN_IFM_FILE	"dvnc.ifm"

#define FALSE	0
#define TRUE	1

#define NAMELEN		1024
#define LANGS_MAX	(ENDLANG_TOK - ILANG_TOK)
#define FONTS_MAX	(LANGS_MAX + 3)

#define LINELEN		1024
	/* max input line len - AFM, IFM files, mainly */

#define	VOWEL_TYPE	1
#define	CONSONANT_SINGLE_TYPE	2
#define	CONSONANT_DOUBLE_TYPE	3
#define	SPECIAL_TYPE	4

#define	CONSONANT_MANY_TYPE	100
#define CONS_MAX	10
	/* maximum number of (half) consonants allowed.
	 * each indian language letter is either a vowel or a
	 * list of half consonants followed by a vowel.
	 */

#define	_I_(ANY_TOK)	((ANY_TOK)-OFFSET_TOK)
	/* _I_ converts a token from the parser to its index in
	 * the 'font_t.enc[_I_()]' array.
	 */

#define _F_(ANY_TOK)	((ANY_TOK)-OFFSET_TOK)
	/* _F_ converts a token from the parser to its form in
	 * the 'font_t.khadi[someconsonant][_F_()]' array.
	 * Note that forms exist only for A_TOK to AHA_TOK.
	 * (additional forms exist, such as HALF_FORM which
	 * have no corresponding parser token)
	 */

#define	A_FORM		(_F_(A_TOK))
#define	AA_FORM		(_F_(AA_TOK))
#define	I_FORM		(_F_(I_TOK))
#define	II_FORM		(_F_(II_TOK))
#define	U_FORM		(_F_(U_TOK))
#define	UU_FORM		(_F_(UU_TOK))
#define	RI_FORM		(_F_(RI_TOK))
#define	RII_FORM	(_F_(RII_TOK))
#define	LI_FORM		(_F_(LI_TOK))
#define	LII_FORM	(_F_(LII_TOK))
#define	AY_FORM		(_F_(AY_TOK))
#define	AAY_FORM	(_F_(AAY_TOK))
#define	AI_FORM		(_F_(AI_TOK))
#define	O_FORM		(_F_(O_TOK))
#define	OO_FORM		(_F_(OO_TOK))
#define	AU_FORM		(_F_(AU_TOK))
#define	AM_FORM		(_F_(AM_TOK))
#define	AHA_FORM	(_F_(AHA_TOK))
#define	HALF_FORM	(AHA_FORM + 1)
#define	IMPLICIT_FORM	(AHA_FORM + 2)

#define NUMFORMS	(AHA_FORM + 3)

/* =================================================================== */
/* PostScript Stuff */

/* EMSIZE will be the current font size
 * EM converts given em size to PostScript point size
 */
#define EMSIZE	"EMSIZE"
#define EMTOPS	"EM"

/* =================================================================== */
/* TeX Stuff */

/* nothing yet */

/* =================================================================== */
/* LETTER_T */
/* Used to pass info from the parser to the application routine */

typedef struct {
    int		type; /* type - vowel, consonant, or
		       * half consonant and another consonant
		       */
    int		cons[CONS_MAX];
    char	nolig[CONS_MAX];
			/* normally, cons[i] and cons[i+1] are checked
			 * for ligatures, and if one exists, it is used.
			 * But, if nolig[i] is TRUE, then no check
			 * is made for ligatures, cons[i] is printed
			 * using its half form.
			 * Naturally, this only applies if n >= 2
			 */
    int		n; /* number of consonants in cons */
    int		v;    /* vowel that goes with c1 or c2 - or is standalone */
}   letter_t;

/* =================================================================== */
/* PSCHAR_T */
typedef struct {
	/* all units are for a 1 point size char, times 1000 */
    int w; /* char width */
    int llx, lly, urx, ury; /* bounding box */
} pschar_t;

/* =================================================================== */
/* COMP_UNIT_T */
/* Each Devnagari Character is a Composite Character.
 * Each composite character is a list of <pcode, deltas> that
 * specify printer the given postscript char pcode, at the given delta.
 * pcode may be IMPLICIT_PSCHAR, implying that this composite char
 * is a complex char (ex: half sa, half ta, yee), and need to get the
 * implicit form the the char.
 * Implicit forms of single chars are directly defined, for multiple
 * forms (as in the above given example) need to compose together
 * all half/implicit forms of the complex char.
 */

#define	IMPLICIT_PSCHAR	-1
#define	NO_PSCHAR	-2

#define DORG_LL		1
#define DORG_CLR	2
	/* the deltas in comp_unit_t may be specied with
	 * respect to the current char origin (DORG_LL), or wrt to the
	 * next char origin (DORG_CLR - current-lower-right)
	 */

typedef struct __comp_unit_t {
    int u_pschar; /* the postscript character code */
		  /* may be IMPLICIT_PSCHAR, implies that the entire
		   * implicit letter has to be printed out at this
		   * point.
		   */
    int deltax, deltay;   /* The offset that is to be used
			   * to print this character.
			   * The offset is wrt to the current position,
			   * depends on the value of the  variable dorg.
			   * (UNLIKE Adobe's Composite Character
			   * defn which is always from char origin)
			   * The delta's refer to a char 1 point
			   * in size, and the delta's are x1000.
			   * If u_pschar == NO_PSCHAR, then
			   * no char is printed, just this delta
			   * is applied.
			   */
    int	dorg; /* specifies whether the offset is wrt current pos
	       * or wrt the origin of the character.
	       * Is usually DORG_CLR, i.e current pos.
	       */
    struct __comp_unit_t* next; /* pointer to the next comp_unit.. */
} comp_unit_t; 

int cus_to_ps P((comp_unit_t* cus, /* chain of PostScript Chars to output */
	      int fsize, /* font size being used for the chars */
	      char pscomm[])); /* the postscript commands returned here */

int cus_to_tex P((comp_unit_t* cus, /* chain of PostScript Chars to output */
	      int fsize, /* font size being used for the chars */
	      char pscomm[])); /* the TeX commands returned here */

/* =================================================================== */
/* DCHAR_T */

typedef struct __dchar_t {
    comp_unit_t**	cus; /* for every form, will allocate NUMFORMS */
    struct __dchar_t*	same_as; /* cus not defined for this, use some
				  * some other character's cus.
				  */
} dchar_t;

/* =================================================================== */
/* following numbers are assigned to font_t.prop data variable */
#define	UNDEF_FONT	0
#define	PS_FONT		1 /* use this font for PostScript out only */
#define	TEX_FONT	2 /* use this font for TeX out only */
#define	TEX_PS_FONT	3 /* use this font for PostScript or TeX out */

/* FONT_T */
typedef struct {

    int			prop; /* font property: Postscript only, TeX
    			       * only, both Tex  and PostScript, etc */

    ifm_enc_t		enc[NUMCHARS];
	/* Every indian lang char token that is returned by the
	 * parser is associated with a name here:
	 * ex, A_TOK from the parser is named "a",
	 * GYA_TOK is named "gya", etc
	 * These names are used to get the khadi, ligatures, etc
	 * from the IFM file for every indian lang form.
	 */

    dchar_t		khadi[NUMKHADI];
	/* the ka, kaa, ki, etc forms, incl vowels.
	 * Vowels have only one form - the "a" form (implicit char form).
	 * Most chars here have khadi[][].cus non-NULL, while
	 * khadi[][].same_as is NULL.
	 */

    dchar_t		ligatures[NUMCHARS][NUMCHARS];
	/* if special chars exist for consonant-consonant pairs:
	 * da-da, dha-da, ta-ta, etc
	 * Most chars here have ligatures[][].cus NULL, while
	 * ligatures[][].same_as is non-NULL.
	 */

    dchar_t		digits[10]; /* the numbers (0..9) themselves */
	/* Most chars here have digits[].cus non-NULL (use A_FORM), while
	 * digits[].same_as is NULL.
	 */

    pschar_t		psfm[NUMPSCHARS]; /* PostScript Font Metrics */	

    char		name[NAMELEN]; /* the font name */
    char		fname[NAMELEN]; /* the ifm file name */
    int			use_ligatures; /* boolean: used by iyacc.y, font.c */
    int			fontno; /* font number - token returned by YACC */
} font_t;

int fillup_font		P((font_t* font, char fname[]));
void init_font		P((font_t* font));
void dump_font		P((font_t* font, FILE* outfp));
int decode_name		P((char inword[], int* l0, int *l1, int* form));
int make_letter		P((font_t* fptr, /* the font data structure to use */
		letter_t dlet, /* letter to convert  */
		comp_unit_t pcus[], /* the comp units that make this
				     * letter - all u_pschar are valid
				     * PostScript codes, or NO_PSCHAR
				     */
		int	size_pcus, /* array size of ecus- number of elements */
		int *ox, int *oy, /* the orgin of this letter */
		int *width)); /* the width of this complete letter */

/* =================================================================== */
/* LANG_T */
typedef struct {
    char*	curr_ifmname; /* the current IFM file name */
    char*	curr_fontcmd; /* the current font command */
    font_t*	curr_font; /* font metrics */
    char*	name; /* language name */
    int		langno; /* token returned by ilex.l */
} lang_t;

void init_langs		P((lang_t* l, int num));
void clear_lang		P((lang_t *l));
void null_lang		P((lang_t *l));

/* =================================================================== */
/* ALLFONTS_T */
typedef font_t*	allfonts_t[FONTS_MAX];

font_t*	find_font	P((allfonts_t af, char fname[]));
FILE*   search_fopen	P((char* path, char* fname, char *mode));
int chk_ext		P((char *path, char *right_ext));

int setifm		P((int lang_tok, char ifmtok[]));
int setfontcmd		P((int lang_tok, char fontcmd[]));
int find_load_ifm	P((lang_t* l, allfonts_t allf, char ifmtok[]));
void process_istart	P((int lang_tok));
void process_iend();

/* ===================================================================== */
#ifdef MSDOS
extern char* yytext; /* for PC flex */
#else
extern char yytext[]; /* for UNIX lex */
#endif
extern int G_lineno;
extern int G_verbose;
extern font_t*	G_current_font;
extern ifm_enc_t G_ifm_map[NUMCHARS];
/* ===================================================================== */
#ifndef PROTO_C
/* 
   Shouldn't really need these prototype defns, but...
   don't know what to do with this, where does this go, ...... 
   I hope that if the user sets PROTO_C in the Makefile, then there
   is some other source of this defn, otherwise, try it here...
*/
extern void* malloc	P((size_t size));
extern char* getenv P((char*));
   /* stdlib.h is missing on many systems, therefore, I don't
    * want to include stdlib.h.
    * since I use only this(these) functions, added
    * it here specifically.
    */

#endif

#ifdef MSDOS
/* MSDOS is missing the getopt function, it is added in utils.c */
extern int getopt	P((int argc, char* argv[], char* optstring));
#endif

/* ===========================^ itrans.h ^============================== */
#undef P
#endif /* ITRANS_H */
