#
#   Makefile for itrans
# $Header: e:/itrans/src/rcs/makefile.tcc 1.2 91/11/28 20:43:37 avinash Exp $
#   This is for PC-compatibles, using Turbo C++ 2.0

#   I do not have a makefile for Microsoft C, but I think these
# changes to this file should do it:
# 1) delete reference to TCC in the SYS line in this file.
# 2) Compile with a LARGE memory model, and change the stack size to
#    be atleast 7000bytes. (i.e, /AL /F1c00)
#
# change all defines as required.

#SHELL=/bin/sh   # use this defn on a unix machine
SHELL=		# use this defn on a pc

####### 
# Note that a shell environment variable has to be defined, called
# ITRANSPATH.
# A sample value for it is:
# ITRANSPATH=$(HEADERPATH):$(TFMDIR), where HEADERPATH and TFMDIR
# will be defined further down in this makefile....
####### 

####### 
# If you do not have a compiler that understands new-style function
# declarators, make the "noansi" object, instead of "itrans" or "all".
# IMPORTANT: Also, make the variable PROTO be null.
####### 

# for SYSV (and friends which use <string.h> instead of <strings.h>)
# define the c-compiler flag
# (add -DMSDOS for 80x86 PC systems (IBM Compatible))
# add -DTCC for Turbo C++ 2.0 Compiler
SYS = -DSYSV -DMSDOS -DTCC

# if your C compiler understands prototypes, define PROTO_C,
# else keep PROTO null
# PROTO =
PROTO=-DPROTO_C=1 -DYY_USE_PROTOS

# where the installed binary goes
# BINDIR = /usr1/avinash/ITRANS/bin
BINDIR = E:\ITRANS\BIN

# where the TFM, and IFM files go
# TFMDIR = /usr/lib/tex/fonts/tfm
TFMDIR=E:\ITRANS\LIB

# where the header PS files go
# HEADERDIR = /usr/lib/tex/ps
HEADERDIR=E:\ITRANS\LIB

# where the manual page goes
# MANDIR = /usr/local/text/man/man1
MANEXT = 1
MANDIR = E:\ITRANS\DOC

# code optimizer
# either use
# OPT = -O2
# OPT = -g
OPT =

# libraries to include (-ll -lm -lc on most systems)
# Note, if you do not have lex/yacc on your system, turn off the
# -ll flag. You will also need to modify the dependencies of
# ilex.o and iyacc.o, check out the comments further down this file
# (look for ilex.o and iyacc.o)
# FLIBS= -lmalloc -ll -lm -lc # Use this for SGI machines
# FLIBS= -lm -lc # Use this for machines missing lex/yacc tools
# FLIBS= -lm -lc
FLIBS= # PC related..., nothing needed

# C flags to use:
# SGI: -acpp use ANSI C prepreocessor, -prototypes, honor prototypes.
# CFLAGS = -acpp -prototypes $(OPT) $(SYS) $(PROTO)
CFLAGS = -ml -N $(OPT) $(SYS) $(PROTO) -w-rch
LFLAGS = -ml

CC=tcc

# Yacc flags:
YFLAGS= -d

###

SRC =	itrans.c \
	iyacc.y \
	ilex.l \
	lang.c \
	font.c \
	pifm.c \
	ichar.c \
	itotex.c \
	itops.c \
	utils.c

OBJ =	itrans.o \
	iyacc.o \
	ilex.o \
	lang.o \
	font.o \
	pifm.o \
	ichar.o \
	itotex.o \
	itops.o \
	utils.o

HEADERFILES = devnac.ps itrans.pro
FILES = 

.c.o:
	$(CC) -c $(CFLAGS) $<
	mv $*.obj $*.o


all : itrans.exe

itrans.exe : $(OBJ)
	tlink -c c:\tc\lib\c0l $(OBJ), itrans,, @tlink.res
#	$(CC) $(LFLAGS) $(OBJ) $(LIBS) $(FLIBS)

$(OBJ) : itrans.h imap.h ifm.h

# .l.c:;
# If you do not have lex on your system, uncomment the following
# four lines (you may leave the .l.c line above as it is)
# Also, comment out the ilex.c that follows this defn (the PC related stuff).
# (it may already be commented....)
#---
# ilex.o : ilex.c ytab.h
# 	$(CC) -c $(CFLAGS) -DNOLEX ilex.c
# ilex.c : lexyyc
# 	cp lexyyc ilex.c

# PC related stuff
ilex.c : ilex.l
	flex ilex.l
	mv lexyy.c ilex.c

# .y.c:;
# If you do not have yacc on your system, uncomment the following
# four lines (you may leave the .y.c:; line above as it is).
# Also, comment out the iyacc.c that follows this defn (the PC related stuff).
# (it may already be commented....)
#---
# iyacc.o : iyacc.c
# 	$(CC) -c $(CFLAGS) iyacc.c
# iyacc.c : ytabc 
# 	cp ytabc iyacc.c

# PC related stuff
iyacc.c : iyacc.y 
	byacc -d iyacc.y
	mv y_tab.c iyacc.c

# When making noansi, make sure PROTO is null
noansi : deansify.exe $(SRC)
	dodeans
	touch noansi
	echo "Make sure the variable PROTO <$(PROTO)> is NULL in the Makefile!"
	make all

deansify.exe:	deansify.c
	$(CC) $(CFLAGS) deansify.c

install : all
	-mkdir $(BINDIR)
	-mkdir $(HEADERDIR)
	-mkdir $(MANDIR)
	copy itrans.exe $(BINDIR)\itrans.exe
	copy prips.bat $(BINDIR)\prips.bat
	-copy ..\lib\itrans.pro $(HEADERDIR)
	-copy ..\lib\devnac.ps $(HEADERDIR)
	-copy ..\lib\devnac.ifm $(TFMDIR)
	-copy ..\lib\devnac.afm $(TFMDIR)
	-copy ..\lib\dnh.tfm $(TFMDIR)
	-copy ..\lib\dnho.tfm $(TFMDIR)
	-copy ..\lib\dnhrc.tfm $(TFMDIR)
	-copy ..\lib\dnhre.tfm $(TFMDIR)
	-copy ..\lib\wntml10.tfm $(TFMDIR)
	-copy ..\lib\wntml12.tfm $(TFMDIR)
	-copy ..\lib\wntml17.tfm $(TFMDIR)
	-attrib -r $(MANDIR)\itrans.man
	-copy ..\doc\itrans.man $(MANDIR)\itrans.man
	-attrib -r $(MANDIR)\prips.man
	-copy ..\doc\prips.man $(MANDIR)\prips.man
	@echo
	@echo "****** Note: There may be error messages printed when installing,"
	@echo "******       most of them will be harmless---directories already existing, or "
	@echo "******       copying a file onto itself."

clean :
	rm -f *.o *.log
