/* -mt -f -A -K -G -O -w */
/* Compile with Turbo-C 2.0 */
/*
  This program generates Japanese font tables

  Author: Francois Jalbert
              '
  Date: November 1990

  Version: 1.0

  Date: April 1991

  Version: 2.0

  Modifications: - Added four kanjis.
                 - Run-time parameters now supplied.
                 - Extension is .JEM now.
                 - Page format changed slightly.
                 - Symbols now centered within tables.
                 - Switched to \clearpage since better for tables.
*/

#include <stdio.h>
#ifdef __TURBOC__
#include <process.h>
#endif

/* Highest Bitmap number in JIS24 */
#define BitmapMax  7806
/* Highest font number */
#define FontMax    60
/* Number of symbols in a font */
#define SymbolMax  128
#define SymbolMax1 127

void FontTable(FILE *OutFile)
{
  int Bitmap;
  int Font;
  int Symbol;
  unsigned char EUC1,EUC2;

  fprintf(OutFile,"%%JEM2TEX /NoSpace /NoPercent /LaTeX /EUC /Extended /3.0\n");
  fprintf(OutFile,"%%\n");
  fprintf(OutFile,"\\documentstyle[12pt]{article}\n");
  fprintf(OutFile,"\\pagestyle{plain}\n");
  fprintf(OutFile,"\\setlength{\\oddsidemargin}{-0.5in} %%0.5in margin left-right\n");
  fprintf(OutFile,"\\setlength{\\textwidth}{7.5in} %%8.5in-2*0.5in\n");
  fprintf(OutFile,"\\setlength{\\topmargin}{-0.25in} %%0.75in margin top-bottom\n");
  fprintf(OutFile,"\\setlength{\\textheight}{9.4in} %%11.0in-2*0.75in\n");
  fprintf(OutFile,"\\setlength{\\footskip}{0.1in}\n");
  fprintf(OutFile,"\\setlength{\\footheight}{0.1in}\n");
  fprintf(OutFile,"\\setlength{\\headheight}{0pt}\n");
  fprintf(OutFile,"\\setlength{\\headsep}{0pt}\n");
  fprintf(OutFile,"\\setlength{\\topskip}{0pt}\n");
  fprintf(OutFile,"\\setlength{\\parindent}{0pt}\n");
  fprintf(OutFile,"\\setlength{\\tabcolsep}{4pt}\n");
  fprintf(OutFile,"\\renewcommand{\\baselinestretch}{0.85}\n");
  fprintf(OutFile,"\\begin{document}\n");
  fprintf(OutFile,"\\begin{Large}\n");
  fprintf(OutFile,"\n");
  fprintf(OutFile,"\\vspace*{\\fill}\n");
  fprintf(OutFile,"\n");
  if (ferror(OutFile)) exit(1);
  for (Bitmap=0 ; Bitmap<=BitmapMax ; Bitmap++) {
    Symbol=Bitmap % SymbolMax;
    Font=Bitmap / SymbolMax;
    EUC1=(unsigned char)((Bitmap-1)/94);
    EUC2=(unsigned char)((Bitmap-1)-94*(int)EUC1);
    EUC1=EUC1+(unsigned char)'\xA1';
    EUC2=EUC2+(unsigned char)'\xA1';
    if (!Symbol) {
      fprintf(OutFile,"\\begin{table}[h]\n");
      fprintf(OutFile," \\centering\n");
      fprintf(OutFile," \\begin{tabular}{r|cccccccccccccccc|l}\n");
      fprintf(OutFile,
              "  Code & \\multicolumn{16}{c|}{Characters} & EUC \\\\ \\hline\n");
      if (ferror(OutFile)) exit(1);
    }
    switch (Symbol % 16) {
      case 0: fprintf(OutFile,"%6d ",Symbol);
              if (ferror(OutFile)) exit(1);
              break;
      case 5: case 10: case 15: fprintf(OutFile,"       ");
                                if (ferror(OutFile)) exit(1);
                                break;
    } 
    if (Bitmap) {
      fprintf(OutFile,"&%c%c",EUC1,EUC2);
      if (ferror(OutFile)) exit(1);
      switch (Symbol % 16) {
        case 4: case 9: case 14: fprintf(OutFile,"\n"); 
                                 if (ferror(OutFile)) exit(1);
                                 break;
        default:if ((Symbol % 16)==15) {
                  fprintf(OutFile,"& %d,%d",EUC1,EUC2);
                  if ( (Symbol!=SymbolMax1) && (Bitmap!=BitmapMax) )
                    fprintf(OutFile," \\\\");
                  fprintf(OutFile,"\n");
                  if (ferror(OutFile)) exit(1);
                }
                else
                  if (Bitmap==BitmapMax) {
                    fprintf(OutFile,"\n");
                    if (ferror(OutFile)) exit(1);
                  }
                break;
      } 
    }
    else {
      fprintf(OutFile,"&  ");
      if (ferror(OutFile)) exit(1);
    }
    if ( (Symbol==SymbolMax1) || (Bitmap==BitmapMax) ) {
      fprintf(OutFile," \\end{tabular}\n");
      fprintf(OutFile,"\\caption{Font {\\tt kanji%c%c} (%d--%d).}\n",
              ('a'+(Font/8)),('a'+(Font % 8)),(Bitmap-Symbol),Bitmap);
      fprintf(OutFile,"\\end{table}\n");
      fprintf(OutFile,"\n");
      if (ferror(OutFile)) exit(1);
      if (Bitmap==BitmapMax) {
        fprintf(OutFile,"\\vspace*{\\fill}\n");
        fprintf(OutFile,"\n");
        if (ferror(OutFile)) exit(1);
      }
      else
        if ((Font % 3)==2) { 
          fprintf(OutFile,"\\vspace*{\\fill}\n");
          fprintf(OutFile,"\n");
          fprintf(OutFile,"\\clearpage\n");
          fprintf(OutFile,"\n");
          fprintf(OutFile,"\\vspace*{\\fill}\n");
          fprintf(OutFile,"\n");
          if (ferror(OutFile)) exit(1);
        }
    }
  }
  fprintf(OutFile,"\\end{Large}\n");
  fprintf(OutFile,"\\end{document}\n");
  if (ferror(OutFile)) exit(1);
}

main()
{
  FILE *OutFile;

  printf("\n");
  printf("Japanese Font Tables Generation Program.\n");/*To make Borland happy*/
  printf("Version 2.0 Copyright F. Jalbert 1991.\n");
  printf("\n");
  if (ferror(stdout)) exit(1);

  printf("Creating Japanese file fontable.jem");
  if ((OutFile=fopen("fontable.jem","wt"))==NULL) exit(1);
  printf(".\n");
  if (ferror(stdout)) exit(1);

  printf("Generating font tables");
  #ifndef __TURBOC__
  printf("\n");
  #endif
  FontTable(OutFile);
  printf(".\n");
  if (ferror(stdout)) exit(1);

  printf("Closing Japanese file fontable.jem");
  if (fclose(OutFile)==EOF) exit(1);
  printf(".\n");
  printf("\n");
  if (ferror(stdout)) exit(1);

  printf("Japanese font tables generation completed.\n");
  printf("\n");
  if (ferror(stdout)) exit(1);

  return(0);
}
