
/* manifests for tiff tags and other oddities */

#define TAG_IMWIDTH	256
#define TAG_IMLENGTH	257
#define TAG_BITSPIX	258
#define TAG_SAMPIX	277
#define TAG_ORIENT	274
#define TAG_PHOTOINTERP	262
#define TAG_SUBFILE	255
#define TAG_COMPRESS	0x103	
#define TAG_CELL_WIDTH	0x108
#define TAG_CELL_LENGTH	0x109
#define	TAG_FILLORD	0x10A
#define TAG_ROW_STRIP	0x116
#define TAG_MINSAMP	0x118
#define TAG_MAXSAMP	0x119
#define TAG_XRES	0x11A
#define	TAG_YRES	0x11B
#define TAG_PLANAR	0x11C
#define TAG_GREYRES	0x122
#define TAG_GREYCRV	0x123

#define FULL_RES	1
#define PLANE_1		1
#define BITSPERBYTE	8

#define FF_TIFF		1
#define FF_EPSF		2

typedef struct ratio {
	long	upper;
	long	lower;
	}RATIO;

struct IMG_ATT {
	char path[40];		/* file name */
	short	resolution;	/* is this the full or sub-sampled */
	short imwidth;		/* width of the image */
	short imlength;		/* length of the image */
	short bits_sample;	/* bits per sample */
	short	compress;	/* compression tag */
	short	photointerp;	/* photointerpretation */
	short	fillorder;	/* order of pixels within a byte */
	short	orient;		/* orientation of the scanned image */
	short	sample_pix;	/* how many samples per pixel */
	long	rows_strip;	/* how many scanned rows per strip */
	short	min_sample;	/* the minimum sample value */
	short 	max_sample;	/* the maximum sample value */
	RATIO	xresolution;	/* the x resolution of the image */
	RATIO	yresolution;	/* the y resolution of the image */
	short	planarconfig;	/* how are the image planes stored */
	short	grey_res_unit;	/* the magnitute multipiler */
	short	*grey_curve;		/* pointer to the grey curve */
					/* should be as many values  */
					/* in the pointed to buffer  */
					/* as there are levels of grey */
	short	cell_width;
	short	cell_lenght;

	};

