/* warn.c
 */
#include "aldtypes.h"
#include "imerr2.h"

/* ErrorMes.c
 */
char *ErrorMessages[] = {
/*  0 */	"null bug",		
/*  1 */	"impossible bug",
/*  2 */	"cannot allocate enough memory",
/*  3 */	"cannot lock memory",
/*  4 */	"no ImageWidth",
/*  5 */	"no ImageLength",
/*  6 */	"no StripOffsets",
/*  7 */	"unsupported value for SamplesPerPixel",
/*  8 */	"unsupported compression type",
/*  9 */	"unsupported photometricInterpretation",
/* 10 */	"unsupported Predictor",
/* 11 */	"unsupported PlanarConfiguration",
/* 12 */	"unsupported BitsPerSample",
/* 13 */	"wrong number of StripOffsets",
/* 14 */	"unknown format",
/* 15 */	"unsupported FillOrder",
/* 16 */	"bad ImageWidth",
/* 17 */	"bad ImageLength",
/* 18 */	"use of this predictor with this bit depth is not supported",
/* 19 */	"this compression type is not recommended",
/* 20 */	"bad TIFF type (not BYTE or ASCII or SHORT or LONG or RATIONAL)",
/* 21 */	"wrong number of BitsPerSample values",
/* 22 */	"strip size is larger than the recomm. max strip size of 10K bytes b4 compression",
/* 23 */	"wrong number of StripByteCounts",
/* 24 */	"no StripByteCounts",
/* 25 */	"bad next-ifd-pointer",
/* 26 */	"PackBits compression but BitsPerSample is not 1",
/* 27 */	"no PhotometricInterpretation",
/* 28 */	"no-longer-recommended bit depth",
/* 29 */	"bad RowsPerStrip",
/* 30 */	"no compression: file is unnecessarily large",
/* 31 */	"PhotometricInterpretation and SamplesPerPixel conflict",
/* 32 */	"no NewSubfileType",
};

void WARN (hwnd, action, errornum)
HWND	hwnd;
WORD	action;
WORD	errornum;
{
	WORD	nEntries;
		
	nEntries = sizeof(ErrorMessages) / sizeof(ErrorMessages[0]);
	if (errornum < nEntries) {
		DBMSG(("warning #%u: %s\n", errornum, ErrorMessages[(errornum)]));
	} else {
		DBMSG(("warning #%u\n", errornum));
	}
}