(******************************************************************************
*                                    hdr3d                                    *
* This unit includes the headers needed for 3D manipulation ..                *
******************************************************************************)
unit hdr3d;

interface

const
   version3dLib = '2.0';

const
    MaxPoints  = 20;
    MaxLines   = 50;
    maxObjects = 9; {size of object table}
    maxNest    = 10; {size of loop table of interpreter}

const ScreenWidth = 1000;
      HalfWidth   = screenWidth / 2;

      radFactor = 180 / 3.1415926535897932385;

type
    line3dPtr = ^ line3d;
    Line3d  = record
       FromP, ToP  : integer;
    end;

    screenPointsPtr = ^ screenPoints;
    screenPoints = record
       sX,sY : integer;
    end;

    axisType = (x,y,z);

type
    point3dPtr = ^ point3d;
    point3d = record
       x, y, z     : real;
    end;

const
       zeroPoint : point3d = (x:0.0; y:0.0; z:0.0);
       xAxis : integer = 45;
       yAxis : integer = 45;

var
{$ifdef windows}
       MaxX, MaxY : word;          { In pixels for graphics screen }
       MaxColor   : word;
{$endif}
       cosine_x,cosine_y,sine_x,sine_y : Real;
       currentPath : string[32];
const
       currentAxis : axisType = x;


Procedure CalcAxisDeg;
procedure setDefaultSuffix(var Fname : string; suffix : string);

implementation

(******************************************************************************
*                                 CalcAxisDeg                                 *
* calculate sines and cosines of axis, xAxis + yAxis = 90 !                   *
******************************************************************************)
Procedure CalcAxisDeg;
begin
     Cosine_X := cos(Xaxis/RadFactor);
     Cosine_Y := cos(Yaxis/RadFactor);
     Sine_X   := sin(Xaxis/RadFactor);
     Sine_Y   := sin(Yaxis/RadFactor);
end; {calcAxisDeg}

(*******************************************************************************
*                              setDefaultSuffix                                *
*   Set the suffix if Fname to .suffix, if it does not have a suffix           *
*******************************************************************************)
procedure setDefaultSuffix;
var
    i  : integer;
begin
    i := length(Fname);
    while (i > 0) and (Fname[i] <> '.') do
       dec(i);
    if (i = 0) then
       Fname := Fname + '.' + suffix;
end; {setDefaultSuffix}

(******************************************************************************
*                                    end.                                     *
******************************************************************************)
begin
       calcAxisDeg;
end.
