{*******************************************************************************
*   Unit name: MCMICE10 interface
*      Author: Martin CEKAL
*        Date: January 15, 1993
*     Version: 1.0
*     Purpose:andle with mouse
********************************************************************************}
UNIT MCMICE10;
{$R-}
interface

type mask = array[1..32] of word;

const {masks for graphic cursor}

Watch:        mask = ($E007,$C003,$8001,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$8001,$C003,
                      $E007,$0,$1FF8,$318C,$6186,$4012,$4022,$4042,$718C,$718C,
                      $4062,$4032,$4002,$6186,$318C,$1FF8,$0);

Arrow:        mask = ($FFFF,$8FFF,$8FFF,$87FF,$83FF,$81FF,$80FF,$807F,$803F,$801F,
                      $800F,$801F,$807F,$887F,$DC3F,$FC3F,$0,$0,$2000,$3000,$3800,
                      $3C00,$3E00,$3F00,$3F80,$3FC0,$3FE0,$3E00,$3300,$2300,$0180,$0180);

UpArrow:      mask = ($f9ff,$f0ff,$e07f,$e07f,$c03f,$c03f,$801f,$801f,$f,$f,$f0ff,
                      $f0ff,$f0ff,$f0ff,$f0ff,$f0ff,$0,$600,$f00,$f00,$1f80,$1f80,
                      $3fc0,$3fc0,$7fe0,$600, $600, $600, $600, $600, $600, $600);

LeftArrow:    mask = ($fe1f,$f01f,$0,$0,$0,$f01f,$fe1f,$ffff,$ffff,$ffff,$ffff,
                      $ffff,$ffff,$ffff,$ffff,$ffff,$0,$c0,$7c0,$7ffe,$7c0,$c0,
                      $0,$0,$0,$0,$0,$0,$0,$0,$0,$0);

CheckMark:    mask = ($fff0,$ffe0,$ffc0,$ff81,$ff03,$607,$f,$1f,$c03f,$f07f,
                      $ffff,$ffff,$ffff,$ffff,$ffff,$ffff,$0,$6,$c,$18,$30,$60,
                      $70c0,$1d80,$700,$0,$0,$0,$0,$0,$0,$0);

PointingHand: mask = ($F3FF,$E1FF,$E1FF,$E1FF,$E1FF,$E049,$E000,$8000,$0,$0,
                      $07FC,$07F8,$9FF9,$8FF1,$C003,$E007,$0C00,$1200,$1200,
                      $1200,$1200,$13B6,$1249,$7249,$9249,$9001,$9001,$8001,
                      $4002,$4002,$2004,$1FF8 );

Diagonalcross:mask = ($7e0,$180,$0,$c003,$f00f,$c003,$0,$180,$7e0,$ffff,$ffff,
                      $ffff,$ffff,$ffff,$ffff,$ffff,$0,$700e,$1c38,$660,$3c0,
                      $660, $1c38,$700e,$0,$0,$0,$0,$0,$0,$0,$0);

RectCross:    mask = ($fc3f,$fc3f,$fc3f,$0,$0,$0,$fc3f,$fc3f,$fc3f,$ffff,$ffff,
                      $ffff,$ffff,$ffff,$ffff,$ffff,$0,$180,$180,$180,$7ffe,$180,
                      $180,$180,$0,$0,$0,$0,$0,$0,$0,$0);

Hourglass:    mask = ($0,$0,$0,$0,$8001,$c003,$e007,$f00f,$e007,$c003,$8001,$0,$0,
                      $0,$0,$ffff,$0,$7ffe,$6006,$300c,$1818,$c30,$660,$3c0,$660,
                      $c30,$1998,$33cc,$67e6,$7ffe,$0,$0);

NewWatch:     mask = ($ffff,$c003,$8001,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$8001,$c003,
                      $ffff,$0,$0,$1ff8,$2004,$4992,$4022,$4042,$518a,$4782,$4002,
                      $4992,$4002,$2004,$1ff8,$0,$0);


{*******************************************************************************
*        Name: InitMouse
*  Parametres: result  =0  mouse driver not found
*                      =1  Microsoft mouse mode
*                      =2  mouse system mouse model
*        Date: June 26, 1992
*     Version: 1.0
*     Purpose: Initialization of mouse
********************************************************************************}
procedure InitMouse(var result:byte);

{*******************************************************************************
*        Name: SetGrCrsr
*  Parametres: x,y coordinates of hot point
*              crssrmask mask of cursor
*        Date: June 26, 1992
*     Version: 1.0
*     Purpose: Set type of graphic cursor
********************************************************************************}
procedure SetGrCrsr(x,y:shortint;crsrmask:mask);

{*******************************************************************************
*        Name: SetTxtCrsr
*  Parametres: hwc=true hardware cursor
*                 =false software cursor;
*              par1: def. of cursor mask
*              par2: def. of cursor
*        Date: June 26, 1992
*     Version: 1.0
*     Purpose: Set type of text cursor
********************************************************************************}
procedure SetTxtCrsr(hwc:boolean;par1,par2:word);

{*******************************************************************************
*        Name: SetMRange
*  Parametres: xl,yl,xh,yh corners of range
*        Date: June 26, 1992
*     Version: 1.0
*     Purpose: Mouse Operating range
********************************************************************************}
procedure SetMRange(xl,yl,xh,yh:integer);

{*******************************************************************************
*        Name: SetMPos
*  Parametres: x,y position of cursor
*        Date: June 26, 1992
*     Version: 1.0
*     Purpose: Set cursor position
********************************************************************************}
procedure SetMPos(x,y:integer);

{*******************************************************************************
*        Name: Crsr
*  Parametres: crsron =true cursor ON
*                     =false cursor OFF
*        Date: June 26, 1992
*     Version: 1.0
*     Purpose: Switch cursor ON/OFF
********************************************************************************}
procedure Crsr(crsron:boolean);

{*******************************************************************************
*        Name: GetMPos
*  Parametres: x,y cursor position
*        Date: June 26, 1992
*     Version: 1.0
*     Purpose: Get cursor position
********************************************************************************}
procedure GetMPos(var x,y:integer);

{*******************************************************************************
*        Name: GetMMotion
*  Parametres: x,y movement of cursor
*        Date: June 26, 1992
*     Version: 1.0
*     Purpose: Movement from last GetMMotion
********************************************************************************}
procedure GetMMotion(var x,y:integer);

{*******************************************************************************
*        Name: PressedButton
*                =true if pressed
*  Parametres: button number of botton 1..3
*        Date: June 26, 1992
*     Version: 1.0
*     Purpose: Checks the button status
********************************************************************************}
function PressedButton(button:byte):boolean;

{*******************************************************************************
*        Name: ReleasedButton
*                =true if released
*  Parametres: button number of botton 1..3
*        Date: June 26, 1992
*     Version: 1.0
*     Purpose: Checks the button status
********************************************************************************}
function ReleasedButton(button:byte):boolean;

{*******************************************************************************
*        Name: WherePress
*  Parametres: button number of botton 1..3
*              x,y coordinates of point
*        Date: June 26, 1992
*     Version: 1.0
*     Purpose: Returns coords of last press
********************************************************************************}
procedure WherePress(Button:Byte;var x,y:integer);

{*******************************************************************************
*        Name: WhereRelease
*  Parametres: button number of botton 1..3
*              x,y coordinates of point
*        Date: June 26, 1992
*     Version: 1.0
*     Purpose: Returns coords of last release
********************************************************************************}
procedure WhereRelease(Button:Byte;var x,y:integer);

{*******************************************************************************
*        Name: SetSensitivity
*  Parametres: x,y number of mouse motions to 8 pixels
*        Date: June 26, 1992
*     Version: 1.0
*     Purpose: Sets sensitivity of mouse
********************************************************************************}
procedure SetSensetivity(x,y : integer);


{*******************************************************************************
*   Unit name: MCMICE10 imlementation
*      Author: Martin CEKAL
*        Date: January 15, 1993
*     Version: 1.0
*     Purpose:andle with mouse
********************************************************************************}
implementation

uses dos;

var regs:registers;

{*******************************************************************************
*        Name: InitMouse
*  Parametres: result  =0  mouse driver not found
*                      =1  Microsoft mouse mode
*                      =2  mouse system mouse model
*        Date: June 26, 1992
*     Version: 1.0
*     Purpose: Initialization of mouse
********************************************************************************}
procedure InitMouse(var result:byte);
var i,b:word;
begin
  if (mem[$0000:$0449]=7) and (mem[$0000:$0465]<>41)
    then begin
      mem[$0000:$0449]:=6;
      regs.AX:=0;
      intr($33,regs);
      i:=regs.AX;
      b:=regs.BX;
      mem[$0000:$0449]:=7;
    end
    else begin
      regs.AX:=0;
      intr($33,regs);
      i:=regs.AX;
      b:=regs.BX;
    end;
  result:=0;                              {Mouse driver not found }
  if (i=$FFFF) and (b=2) then result:=1;  {Microsoft Mouse mode   }
  if (i=$FFFF) and (b=3) then result:=2;  {Mouse System Mouse mode}
end; {*** end InitMouse ***}

{*******************************************************************************
*        Name: SetGrCrsr
*  Parametres: x,y coordinates of hot point
*              crssrmask mask of cursor
*        Date: June 26, 1992
*     Version: 1.0
*     Purpose: Set type of graphic cursor
********************************************************************************}
procedure SetGrCrsr(x,y:shortint;crsrmask:mask);
begin
  regs.AX:=9;
  regs.BX:=x;
  regs.CX:=y;
  regs.DX:=ofs(crsrmask);
  regs.ES:=seg(crsrmask);
  intr($33,regs);
end; {*** end SetGrCrsr ***}

{*******************************************************************************
*        Name: SetTxtCrsr
*  Parametres: hwc=true hardware cursor
*                 =false software cursor;
*              par1: def. of cursor mask
*              par2: def. of cursor
*        Date: June 26, 1992
*     Version: 1.0
*     Purpose: Set type of text cursor
********************************************************************************}
procedure SetTxtCrsr(hwc:boolean;par1,par2:word);
begin
  regs.AX:=10;
  if hwc then regs.BX:=1
         else regs.BX:=0;
  regs.CX:=par1;
  regs.DX:=par2;
  intr($33,regs);
end; {*** end SetTxtCrsr ***}

{*******************************************************************************
*        Name: SetMRange
*  Parametres: xl,yl,xh,yh corners of range
*        Date: June 26, 1992
*     Version: 1.0
*     Purpose: Mouse Operating range
********************************************************************************}
procedure SetMRange(xl,yl,xh,yh:integer);
begin
  regs.AX:=7;
  regs.CX:=xl;
  regs.DX:=xh;
  intr($33,regs);
  regs.AX:=8;
  regs.CX:=yl;
  regs.DX:=yh;
  intr($33,regs);
end; {*** end SetMRange ***}

{*******************************************************************************
*        Name: SetMPos
*  Parametres: x,y position of cursor
*        Date: June 26, 1992
*     Version: 1.0
*     Purpose: Set cursor position
********************************************************************************}
procedure SetMPos(x,y:integer);
begin
  regs.AX:=4;
  regs.CX:=x;
  regs.dx:=y;
  intr($33,regs);
end; {*** end SetMPos ***}

{*******************************************************************************
*        Name: Crsr
*  Parametres: crsron =true cursor ON
*                     =false cursor OFF
*        Date: June 26, 1992
*     Version: 1.0
*     Purpose: Switch cursor ON/OFF
********************************************************************************}
procedure Crsr(crsron:boolean);
begin
  if crsron then regs.AX:=1
            else regs.AX:=2;
  intr($33,regs);
end; {*** end Crsr ***}

{*******************************************************************************
*        Name: GetMPos
*  Parametres: x,y cursor position
*        Date: June 26, 1992
*     Version: 1.0
*     Purpose: Get cursor position
********************************************************************************}
procedure GetMPos(var x,y:integer);
begin
  regs.AX:=3;
  intr($33,regs);
  x:=regs.CX;
  y:=regs.DX;
end; {*** end GetMPos ***}

{*******************************************************************************
*        Name: GetMMotion
*  Parametres: x,y movement of cursor
*        Date: June 26, 1992
*     Version: 1.0
*     Purpose: Movement from last GetMMotion
********************************************************************************}
procedure GetMMotion(var x,y:integer);
begin
  regs.AX:=11;
  intr($33,regs);
  x:=regs.CX;
  y:=regs.DX;
end; {*** end GetMMotion ***}

{*******************************************************************************
*        Name: PressedButton
*                =true if pressed
*  Parametres: button number of botton 1..3
*        Date: June 26, 1992
*     Version: 1.0
*     Purpose: Checks the button status
********************************************************************************}
function PressedButton(button:byte):boolean;
begin
  regs.AX:=3;
  intr($33,regs);
  pressedbutton:=((1 shl (button-1)) and regs.BX)<>0;
end; {*** end PressedButton ***}

{*******************************************************************************
*        Name: ReleasedButton
*                =true if released
*  Parametres: button number of botton 1..3
*        Date: June 26, 1992
*     Version: 1.0
*     Purpose: Checks the button status
********************************************************************************}
function ReleasedButton(button:byte):boolean;
begin
  regs.AX:=6;
  intr($33,regs);
  releasedbutton:=((1 shl (button-1)) and regs.BX)<>0;
end; {*** end ReleaseButton ***}

{*******************************************************************************
*        Name: WherePress
*  Parametres: button number of botton 1..3
*              x,y coordinates of point
*        Date: June 26, 1992
*     Version: 1.0
*     Purpose: Returns coords of last press
********************************************************************************}
procedure WherePress(Button:Byte;var x,y:integer);
begin
  regs.AX := 5;
  regs.BX := Button-1;
  intr($33,regs);
  x:= regs.cx;
  y:= regs.dx;
end; {*** end WherePress ***}

{*******************************************************************************
*        Name: WhereRelease
*  Parametres: button number of botton 1..3
*              x,y coordinates of point
*        Date: June 26, 1992
*     Version: 1.0
*     Purpose: Returns coords of last release
********************************************************************************}
procedure WhereRelease(Button:Byte;var x,y:integer);
begin
  regs.ax := 6;
  regs.bx := Button-1;
  intr($33,regs);
  X := regs.cx;
  Y := regs.dx;
end; {*** end WhereRelease ***}

{*******************************************************************************
*        Name: SetSensitivity
*  Parametres: x,y number of mouse motions to 8 pixels
*        Date: June 26, 1992
*     Version: 1.0
*     Purpose: Sets sensitivity of mouse
********************************************************************************}
procedure SetSensetivity(x,y : integer);
begin
  regs.ax := 15;
  regs.cx := x; {# of mouse motions to horizontal 8 pixels}
  regs.dx := y; {# of mouse motions to vertical 8 pixels}
  intr($33,regs);
end; {*** end SetSensitivity ***}

End. {*** unit MCMICE10 ***}




