{ What keeps you going on a late night hack? - 'Twice the Caffeine' }

Program JoltCola;
uses TpUnpack, VGABios;

{$M 30000, 0, 65536 }

{$R- }

Type
  BufType      = Array[1..65520] of Byte;

Var
  LastMode     : Byte;
  JoltColaBuf  : ^BufType;
  VGAScreen    : BufType absolute $A000:$0000;

{ Colour table of picture: 256 registers, 3 bytes (R, G, B) each }

Procedure JoltColaDAC; External;
{$L JCOLADAC.OBJ }

Function JoltColaSize : Word; Far; External;
Procedure UnpackJoltCola(Var buffer); Far; External;
{$L JOLTCOLA.OBJ }

Procedure InitScreenColours; Assembler;

ASM
        MOV    AX, 13h         { Set VGA Mode 13h: 320x200x256 }
        INT    10h
        MOV    AX, 1012h       { Set block of DAC registers }
        MOV    CX, 256
        XOR    BX, BX
        PUSH   CS
        POP    ES
        MOV    DX, Offset JoltColaDac
        INT    10h
end;  { InitScreenColours }

Procedure WaitForKeypress; Assembler;

ASM
        MOV    AX, 0C07h
        INT    21h
end;  { WaitForKeypress }

Procedure DimDisplay; Assembler;

ASM
        PUSH   DS
        MOV    AX, CS
        MOV    DS, AX
        MOV    ES, AX
        MOV    BX, MaxIntensity

  { VGA port 3C8h: PEL address register, (colour index, with auto increment)
    VGA port 3C9h: PEL write register (R, G, B) }

        CLD
@1:     LEA    SI, JoltColaDAC
        MOV    DI, SI
        MOV    CX, 3*256
        XOR    AX, AX
        MOV    DX, 3C8h
        OUT    DX, AL
        INC    DX

  { Get colour value, decrement it and update the table }

@2:     LODSB
        OR     AX, AX
        JZ     @3
        DEC    AX
@3:     STOSB
        OUT    DX, AL
        LOOP   @2

  { Delay before next decrement of R, G, B values }

        MOV    CX, 30000
@4:     LOOP   @4
        DEC    BX
        OR     BX, BX
        JNZ    @1
        POP    DS
end;  { DimDisplay }

Begin
  If VGAStatus = NotVGA Then
    Begin
      WriteLn('This program requires a VGA adapter.');
      Exit;
    end;
  LastMode := GetVideoMode;
  InitScreenColours;
  New(JoltColaBuf);
  UnpackJoltCola(JoltColaBuf^);
  VGAScreen := JoltColaBuf^;
  WaitForKeypress;
  DimDisplay;
  SetVideoMode(LastMode);
end.  { JoltCola }