
; *******************************************************
; *                                                     *
; *     Turbo Pascal Runtime Library Version 6.0        *
; *     Real Multiple Precision Argument Reduction      *
; *                                                     *
; *     Copyright (C) 1991,1992 Norbert Juffa           *
; *                                                     *
; *******************************************************

             TITLE   F48FRED

             INCLUDE SE.ASM


CODE         SEGMENT BYTE PUBLIC

             ASSUME  CS:CODE

; Externals

             EXTRN   RealAdd:NEAR,RealMulNoChk:NEAR,RealMul:NEAR

; Publics

             PUBLIC  RealReduceMP


;-----------------------------------------------------------------------------
; Routine RealReduceMP realizes an extended precision argument reduction as
; needed in the calculation of trigonometric functions Sin, Cos, and Tan and
; in the Exp function. In the argument reduction for these functions there is
; the danger of a great loss of precision due to cancelling when subtracting
; numbers of nearly equal magnitude. The reduction usually calls for the
; subtraction of some multiple n of a constant c from the argument x. The
; precision can be increased if the constant is split into two parts, c1 and
; c2, with c1 being the most significant part and c2 being the least
; significant part and c1+c2=c with more bits of precision than there are
; bits in the mantissa of the floating point format used for the calculations.
; Instead of computing x - n*c, the calculation is done as x - n*c1 - n*c2,
; where it is important that n*c1 can be exactly represented in the floating
;point format used.
;
; INPUT:     DX:BX:AX  n
;            DI:SI:CX  x
;            CS:BP     Pointer to table containing two REAL constants c1,c2
;
; OUTPUT:    DX:BX:AX  x + n*c1 + n*c2
;
; DESTROYS:  AX,BX,CX,DX,SI,DI,Flags
;------------------------------------------------------------------------------

RealReduceMP PROC    NEAR
             PUSH    DX                ; save
             PUSH    BX                ;  n on
             PUSH    AX                ;   stack
             PUSH    DI                ; save x
             PUSH    SI                ;  on
             PUSH    CX                ;   stack
             MOV     CX, CS:[BP+0]     ; get c1
             MOV     SI, CS:[BP+2]     ;  from constant table
             MOV     DI, CS:[BP+4]     ;   pointed to by CS:BP
             CALL    RealMulNoChk      ; compute n*c1
             POP     CX                ; get
             POP     SI                ;  back
             POP     DI                ;   x
             CALL    RealAdd           ; compute x + n*c1
             POP     CX                ; get
             POP     SI                ;  back
             POP     DI                ;   n
             PUSH    DX                ; save
             PUSH    BX                ;  x + n*c1
             PUSH    AX                ;   on stack
             MOV     AX, CS:[BP+6]     ; get
             MOV     BX, CS:[BP+8]     ;  c2 from
             MOV     DX, CS:[BP+10]    ;   constant table
             CALL    RealMul           ; compute n*c2
             POP     CX                ; get
             POP     SI                ;  back
             POP     DI                ;   x + n*c1
             JMP     RealAdd           ; compute x + n*c1 + n*c2 and return
RealReduceMP ENDP

             ALIGN   4

CODE         ENDS

             END
