PROGRAM DExp;    { ported from Fortran original 05-01-92 Norbert Juffa }

{$A+,B-,D-,E+,F-,G-,I-,L-,N-,O-,R-,S-,V-,X-}

USES MachArit, Power;

{     PROGRAM TO TEST DEXP
C
C     DATA REQUIRED
C
C        NONE
C
C     SUBPROGRAMS REQUIRED FROM THIS PACKAGE
C
C        MACHAR - AN ENVIRONMENTAL INQUIRY PROGRAM PROVIDING
C                 INFORMATION ON THE FLOATING-POINT ARITHMETIC
C                 SYSTEM.  NOTE THAT THE CALL TO MACHAR CAN
C                 BE DELETED PROVIDED THE FOLLOWING FOUR
C                 PARAMETERS ARE ASSIGNED THE VALUES INDICATED
C
C                 IBETA - THE RADIX OF THE FLOATING-POINT SYSTEM
C                 IT    - THE NUMBER OF BASE-IBETA DIGITS IN THE
C                         SIGNIFICAND OF A FLOATING-POINT NUMBER
C                 XMIN  - THE SMALLEST NON-VANISHING FLOATING-POINT
C                         POWER OF THE RADIX
C                 XMAX  - THE LARGEST FINITE FLOATING-POINT NO.
C
C        REN(K) - A FUNCTION SUBPROGRAM RETURNING RANDOM REAL
C                 NUMBERS UNIFORMLY DISTRIBUTED OVER (0,1)
C
C
C     STANDARD FORTRAN SUBPROGRAMS REQUIRED
C
C         DABS, DINT, DLOG, DMAX1, DEXP, DFLOAT, DSQRT
C
C
C     LATEST REVISION - DECEMBER 6, 1979
C
C     AUTHOR - W. J. CODY
C              ARGONNE NATIONAL LABORATORY
C
}



FUNCTION REN (K: LONGINT): REAL;

{
      DOUBLE PRECISION FUNCTION REN(K)
C
C     RANDOM NUMBER GENERATOR - BASED ON ALGORITHM 266 BY PIKE AND
C      HILL (MODIFIED BY HANSSON), COMMUNICATIONS OF THE ACM,
C      VOL. 8, NO. 10, OCTOBER 1965.
C
C     THIS SUBPROGRAM IS INTENDED FOR USE ON COMPUTERS WITH
C      FIXED POINT WORDLENGTH OF AT LEAST 29 BITS.  IT IS
C      BEST IF THE FLOATING POINT SIGNIFICAND HAS AT MOST
C      29 BITS.
C
}

VAR   J:  LONGINT;
CONST IY: LONGINT = 100001;

BEGIN
   J  := K;
   IY := IY * 125;
   IY := IY - (IY DIV 2796203) * 2796203;
   REN:= 1.0 * (IY) / 2796203.0e0 * (1.0e0 + 1.0e-6 + 1.0e-12);
END;



FUNCTION MAX1 (A, B:REAL): REAL;
BEGIN
   IF A > B THEN
      MAX1 := A
   ELSE
      MAX1 := B;
END;



VAR   I,IBETA,IEXP,IOUT,IRND,IT,I1,J,K1,K2,K3,MACHEP,
      MAXEXP,MINEXP,N,NEGEP,NGRD: LONGINT;
      A,AIT,ALBETA,B,BETA,D,DEL,EPS,EPSNEG,ONE,R6,R7,
      TWO,TEN,V,W,X,XL,XMAX,XMIN,XN,X1,Y,Z,ZERO,ZZ,
      HALF,NINETENTH,FOUR,FORTYFIVE,SIXTEEN,SIXTEENTH,
      SIXHUNDREDTH: REAL;

LABEL 100, 110, 120, 270, 300;


BEGIN

   N := 1000000;    { number of trials }

   MACHAR (IBETA,IT,IRND,NGRD,MACHEP,NEGEP,IEXP,MINEXP,MAXEXP,
           EPS,EPSNEG,XMIN,XMAX);
   PRINTPARAM (IBETA,IT,IRND,NGRD,MACHEP,NEGEP,IEXP,MINEXP,MAXEXP,
               EPS,EPSNEG,XMIN,XMAX);
   BETA         := IBETA;
   ALBETA       := LN (BETA);
   AIT          := IT;
   ZERO         := 0;
   ONE          := 1;
   TWO          := 2;
   FOUR         := 4;
   TEN          := 10;
   SIXTEEN      := 16;
   FORTYFIVE    := 45;
   HALF         := 0.5;
   NINETENTH    := 0.9;
   SIXTEENTH    := 0.0625;
   SIXHUNDREDTH := 0.006;
   V            := SIXTEENTH;
   A            := TWO;
   B            := LN (A) * HALF;
   A            := -B + V;
   D            := LN (NINETENTH*XMAX);
   XN           := N;
   I1           := 0;

{---------------------------------------------------------------------}
{     RANDOM ARGUMENT ACCURACY TESTS                                  }
{---------------------------------------------------------------------}

   FOR J := 1 TO 3 DO BEGIN
      K1 := 0;
      K3 := 0;
      X1 := ZERO;
      R6 := ZERO;
      R7 := ZERO;
      DEL:= (B - A) / XN;
      XL := A;

      FOR I := 1 TO N DO BEGIN
         X := DEL * REN(I1) + XL;

{---------------------------------------------------------------------}
{     PURIFY ARGUMENTS                                                }
{---------------------------------------------------------------------}

         Y := X - V;
         IF Y < ZERO THEN
            X := Y + V;
         Z  := EXP (X);
         ZZ := EXP (Y);
         IF J = 1 THEN
            GOTO 100;
         IF IBETA <> 10 THEN
            Z := Z * SIXTEENTH - Z *
                 2.4453321046920570389e-3; { 1/16 - exp (-45/16) }
         IF IBETA = 10 THEN
            Z := Z * SIXHUNDREDTH +  Z *
                 5.466789530794296106e-5;  { 6/100 - exp (-45/16) }
         GOTO 110;
100:     Z := Z - Z * 6.058693718652421388e-2;  { 1 - exp (-1/16) }
110:     IF Z <> ZERO THEN
            W := (Z - ZZ) / Z
         ELSE IF ZZ <> 0 THEN
            W := ONE;
         IF W > ZERO THEN
            K1 := K1 + 1;
         IF W < ZERO THEN
            K3 := K3 + 1;
         W := ABS (W);
         IF W <= R6 THEN
            GOTO 120;
         R6 := W;
         X1 := X;
120:     R7 := R7 + W * W;
         XL := XL + DEL;
      END;

      K2 := N - K3 - K1;
      R7 := SQRT (R7/XN);

      WRITELN;
      WRITELN;
      WRITELN ('TEST OF EXP (X-', V:15, ') VS EXP(X)/EXP(', V:15, ')');
      WRITELN;
      WRITELN (N, ' RANDOM ARGUMENTS WERE TESTED FROM THE INTERVAL');
      WRITELN ('(', A, ',', B, ')');
      WRITELN;
      WRITELN ('EXP(X-V) WAS LARGER', K1:6, ' TIMES');
      WRITELN ('             AGREED', K2:6, ' TIMES');
      WRITELN ('    AND WAS SMALLER', K3:6, ' TIMES');
      WRITELN;
      WRITELN ('THERE ARE ', IT, ' BASE ', IBETA,
               ' SIGNIFICANT DIGITS IN A FLOATING-POINT NUMBER');
      WRITELN;
      W := -999;
      IF R6 <> ZERO THEN
         W := LN (ABS(R6))/ALBETA;
      WRITELN ('THE MAXIMUM RELATIVE ERROR OF          ', R6:12,
               ' = ', IBETA, ' **', W:7:2);
      WRITELN ('OCCURED FOR X = ', X1);
      W := MAX1 (AIT+W,ZERO);
      WRITELN;
      WRITELN ('THE ESTIMATED LOSS OF BASE ', IBETA,
               ' SIGNIFICANT DIGITS IS        ', W:7:2);
      W := -999.0;
      IF R7 <> ZERO THEN
         W := LN (ABS(R7))/ALBETA;
      WRITELN;
      WRITELN ('THE ROOT MEAN SQUARE RELATIVE ERROR WAS', R7:12,
               ' = ', IBETA, ' **' , W:7:2);
      W := MAX1 (AIT+W,ZERO);
      WRITELN;
      WRITELN ('THE ESTIMATED LOSS OF BASE ', IBETA,
               ' SIGNIFICANT DIGITS IS        ', W:7:2);
      IF J = 2 THEN
         GOTO 270;
      V := FORTYFIVE / SIXTEEN;
      A := -TEN * B;
      B := FOUR * XMIN * POW (BETA ,IT);
      B := LN (B);
      GOTO 300;
270:  A := -TWO * A;
      B := TEN * A;
      IF B < D THEN
         B := D;
300:
   END;

{---------------------------------------------------------------------}
{    SPECIAL TESTS                                                    }
{---------------------------------------------------------------------}

   WRITELN;
   WRITELN;
   WRITELN ('SPECIAL TESTS');
   WRITELN;
   WRITELN ('THE IDENTITY EXP(X)*EXP(-X) = 1.0 WILL BE TESTED');
   WRITELN;
   WRITELN ('          X           F(X)*F(-X)-1');

   FOR I := 1 TO 5 DO BEGIN
      X := REN(I1) * BETA;
      Y := -X;
      Z := EXP(X) * EXP(Y);
      Z := Z - ONE;
      WRITELN (X:18, Z:18);
   END;

   WRITELN;
   WRITELN;
   WRITELN ('TEST OF SPECIAL ARGUMENTS');
   X := ZERO;
   Y := EXP (X) - ONE;
   WRITELN;
   WRITELN ('EXP (0.0) - 1.0 = ', Y:15);
   X := INT (LN(XMIN));
   Y := EXP (X);
   WRITELN;
   WRITELN ('EXP (', X:15, ') = ', Y:15);
   X := INT (LN(XMAX));
   Y := EXP (X);
   WRITELN;
   WRITELN ('EXP (', X:15, ') = ', Y:15);
   X := X / TWO;
   V := X / TWO;
   Y := EXP (X);
   Z := EXP (V);
   Z := Z * Z;
   WRITELN;
   WRITELN ('IF EXP (', X:15, ') = ', Y:15, ' IS NOT ABOUT ');
   WRITELN ('EXP (', V:15, ')**2 = ', Z:15, ' THERE IS AN ARG RED ERROR');

{---------------------------------------------------------------------}
{     TEST OF ERROR RETURNS                                           }
{---------------------------------------------------------------------}

   WRITELN;
   WRITELN;
   WRITELN ('TEST OF ERROR RETURNS');
   WRITELN;
   X := -ONE / SQRT (XMIN);
   WRITELN ('EXP WILL BE CALLED WITH THE ARGUMENT ', X:15);
   Y := EXP (X);
   WRITELN ('EXP RETURNED THE VALUE', Y:15);
   WRITELN;
   X := -X;
   WRITELN ('EXP WILL BE CALLED WITH THE ARGUMENT ', X:15);
   WRITELN ('THIS SHOULD TRIGGER AN ERROR MESSAGE');
   Y := EXP (X);
   WRITELN ('EXP RETURNED THE VALUE', Y:15);
   WRITELN;
   WRITELN ('THIS CONCLUDES THE TESTS');
END. { DExp }
