{$A+,B-,D+,E+,F-,I-,L-,N+,O-,R-,S-,V-}
{$M 16384,0,655360}

PROGRAM Fun1_Test;

USES Math, Fun1_TP6;

VAR  RandomNr:   ARRAY [0..10760] OF REAL;
     R, R2:      REAL;
     X, Y,
     MaxY:       EXTENDED;
     I, J, L,
     ErrCountY:  LONGINT;

CONST
    {$IFDEF VER40}
    Ver = '4.0';
    {$ENDIF}
    {$IFDEF VER50}
    Ver = '5.0';
    {$ENDIF}
    {$IFDEF VER55}
    Ver = '5.5';
    {$ENDIF}
    {$IFDEF VER60}
    Ver = '6.0';
    {$ENDIF}
    {$IFDEF VER70}
    Ver = '7.0';
    {$ENDIF}


BEGIN
   WriteLn;
   WriteLn ('Testing for errors in the basic arithmetic operations of TP '+Ver);
   WriteLn;
   WriteLn ('There should be no errors reported and relative error should be below');
   WriteLn (PowerOfTwo (-40), ' for all functions that are tested. The test ');
   WriteLn ('will take some time to complete, especially when using the emulator.');
   WriteLn ('');
   RandSeed := 12345;
   FOR L := 0 TO 10760 DO BEGIN
      RandomNr [L] := Exp (Random * 87);
   END;
   ErrCountY := 0;
   MaxY := 0;
   FOR L := 1 TO 10000000 DO BEGIN
      X := RandomNr [L MOD 10739] + RandomNr [(L + 101) MOD 10753];
      Y := Add_TP60 (RandomNr [L MOD 10739], RandomNr [(L + 101) MOD 10753]);
      R := X;
      R2:= Y;
      IF (X <> Y) THEN BEGIN
         IF Abs ((Y-X) / X) > MaxY THEN
            MaxY := Abs ((Y-X) / X);
         IF (R <> R2) THEN
            Inc (ErrCountY);
         END;
   END;
   WriteLn ('errors in addition:');
   WriteLn;
   Write   ('Turbo-Pascal '+Ver+': ', ErrCountY / 100000.0:5:4, '%    ');
   WriteLn ('(max. relative error:   ', MaxY:18, ')');
   WriteLn;
   WriteLn;
   MaxY := 0;
   ErrCountY := 0;
   FOR L := 1 TO 10000000 DO BEGIN
      X := RandomNr [L MOD 10739] - RandomNr [(L + 101) MOD 10753];
      Y := Add_TP60 (RandomNr [L MOD 10739], -(RandomNr [(L + 101) MOD 10753]));
      R := X;
      R2:= Y;
      IF (X <> Y) THEN BEGIN
         IF Abs ((Y-X) / X) > MaxY THEN
            MaxY := Abs ((Y-X) / X);
         IF (R <> R2) THEN
            Inc (ErrCountY);
         END;
   END;
   WriteLn ('errors in subtraction: ');
   WriteLn;
   Write   ('Turbo-Pascal '+Ver+': ', ErrCountY / 100000.0:5:4, '%    ');
   WriteLn ('(max. relative error:   ', MaxY:18, ')');
   WriteLn;
   WriteLn;

   FOR L := 0 TO 10760 DO BEGIN
      RandomNr [L] := Exp (Random * 43) * (Random - 1);
      IF RandomNr [L] = 0 THEN
         RandomNr[L] := 0.1;
   END;
   MaxY := 0;
   ErrCountY := 0;
   FOR L := 1 TO 100 DO BEGIN
      X := RandomNr [L MOD 10739] * RandomNr [(L + 101) MOD 10753];
      Y := Mul_TP60 (RandomNr [L MOD 10739], RandomNr [(L + 101) MOD 10753]);
      R := X;
      R2:= Y;
      IF (X <> Y) THEN BEGIN
         IF Abs ((Y-X) / X) > MaxY THEN
            MaxY := Abs ((Y-X) / X);
         IF (R <> R2) THEN
            Inc (ErrCountY);
         END;
   END;
   WriteLn ('errors in multiplication: ');
   WriteLn;
   Write   ('Turbo-Pascal '+Ver+': ', ErrCountY / 100000.0:5:4, '%    ');
   WriteLn ('(max. relative error:   ', MaxY:18, ')');

   WriteLn;
   WriteLn;
   MaxY := 0;
   ErrCountY := 0;
   FOR L := 1 TO 10760 DO BEGIN
      X := Sqr (RandomNr [L]);
      Y := Sqr_TP60 (RandomNr [L]);
      R := X;
      R2:= Y;
      IF (X <> Y) THEN BEGIN
         IF Abs ((Y-X) / X) > MaxY THEN
            MaxY := Abs ((Y-X) / X);
         IF (R <> R2) THEN
            Inc (ErrCountY);
         END;
   END;
   WriteLn ('errors in squaring: ');
   WriteLn;
   Write   ('Turbo-Pascal '+Ver+': ', ErrCountY / 107.6:5:4, '%    ');
   WriteLn ('(max. relative error:   ', MaxY:18, ')');
   WriteLn;
   WriteLn;
   MaxY := 0;
   ErrCountY := 0;
   FOR L := 1 TO 10000000 DO BEGIN
      X := RandomNr [L MOD 10739] * Abs (Trunc (RandomNr [(L + 101) MOD 10753] / 8e13));
      Y := Mul_TP60 (RandomNr [L MOD 10739], Abs (Trunc (RandomNr [(L + 101) MOD 10753]/8e13)));
      R := X;
      R2:= Y;
      IF (X <> Y) THEN BEGIN
         IF Abs ((Y-X) / X) > MaxY THEN begin
            MaxY := Abs ((Y-X) / X);
            end;
         IF (R <> R2) THEN
            Inc (ErrCountY);
         END;
   END;
   WriteLn ('errors in SHORT-multiplication: ');
   WriteLn;
   Write   ('Turbo-Pascal '+Ver+': ', ErrCountY / 100000.0:5:4, '%    ');
   WriteLn ('(max. relative error:   ', MaxY:18, ')');
   WriteLn;
   WriteLn;
   MaxY := 0;
   ErrCountY := 0;
   FOR L := 1 TO 10760 DO BEGIN
      X := Sqr (1.0*Trunc(RandomNr [L] / 8e13+1));
      Y := Sqr_TP60 (Trunc(RandomNr [L] / 8e13+1));
      R := X;
      R2:= Y;
      IF (X <> Y) and (X <> 0) THEN BEGIN
         IF Abs ((Y-X) / X) > MaxY THEN
            MaxY := Abs ((Y-X) / X);
         IF (R <> R2) THEN
            Inc (ErrCountY);
         END;
   END;
   WriteLn ('errors in squaring (Short): ');
   WriteLn;
   Write   ('Turbo-Pascal '+Ver+': ', ErrCountY / 107.6:5:4, '%    ');
   WriteLn ('(max. relative error:   ', MaxY:18, ')');
   WriteLn;
   WriteLn;
   MaxY := 0;
   ErrCountY := 0;
   FOR L := 1 TO 10000000 DO BEGIN
      X := RandomNr [L MOD 10739] / RandomNr [(L + 101) MOD 10753];
      Y := Div_TP60 (RandomNr [L MOD 10739], RandomNr [(L + 101) MOD 10753]);
      R := X;
      R2:= Y;
      IF (X <> Y) THEN BEGIN
         IF Abs ((Y-X) / X) > MaxY THEN
            MaxY := Abs ((Y-X) / X);
         IF (R <> R2) THEN
            Inc (ErrCountY);
         END;
   END;
   WriteLn ('errors in division: ');
   WriteLn;
   Write   ('Turbo-Pascal '+Ver+': ', ErrCountY / 100000.0:5:4, '%    ');
   WriteLn ('(max. relative error:   ', MaxY:18, ')');
   WriteLn;
   halt;
   WriteLn;
   MaxY := 0;
   ErrCountY := 0;
   FOR L := 1 TO 10760 DO BEGIN
      X := Int (RandomNr [L]) + Frac (RandomNr [L]);
      Y := Int_TP60 (RandomNr [L]) + Frac_TP60 (RandomNr [L]);
      R := X;
      R2:= Y;
      IF (X <> Y) THEN BEGIN
         IF Abs ((Y-X) / X) > MaxY THEN
            MaxY := Abs ((Y-X) / X);
         IF (R <> R2) THEN
            Inc (ErrCountY);
         END;
   END;
   WriteLn ('errors in Int / Frac: ');
   WriteLn;
   Write   ('Turbo-Pascal '+Ver+': ', ErrCountY / 107.6:5:4, '%    ');
   WriteLn ('(max. relative error:   ', MaxY:18, ')');
   WriteLn;
   WriteLn;
   MaxY := 0;
   ErrCountY := 0;
   FOR L := 1 TO 10760 DO BEGIN
      RandomNr [L] := RandomNr [L] /2.5e9;
      X := Trunc (RandomNr [L]);
      Y := Float_TP60 (Trunc_TP60 (RandomNr [L]));
      R := X;
      R2:= Y;
      IF (X <> Y) THEN BEGIN
         IF Abs ((Y-X) / X) > MaxY THEN
            MaxY := Abs ((Y-X) / X);
         IF (R <> R2) THEN
            Inc (ErrCountY);
         END;
   END;
   WriteLn ('errors in Trunc / Float: ');
   WriteLn;
   Write   ('Turbo-Pascal '+Ver+': ', ErrCountY / 107.6:5:4, '%    ');
   WriteLn ('(max. relative error:   ', MaxY:18, ')');
   WriteLn;
END.
