unit strings;

{ Written by William C. Thompson }

{ This unit was written to do a few basic things with strings }

interface

function allup(s:string):string;
function lowcase(c:char):char;
function alllow(s:string):string;
function rep(s:string; n:integer):string;
function leftpad(s:string; n:byte):string;
procedure reverse(var s:string);
procedure spacechop(var s:string);

implementation

function allup(s:string):string;
var i:byte;
begin
  for i:=1 to length(s) do s[i]:=upcase(s[i]);
  allup:=s
end;

function lowcase(c:char):char;
begin
  if c in ['A'..'Z'] then c:=chr(ord(c)+32);
  lowcase:=c
end;

function alllow(s:string):string;
var i:byte;
begin
  for i:=1 to length(s) do s[i]:=lowcase(s[i]);
  alllow:=s
end;

function rep(s:string; n:integer):string;
var
  t: string;
  i: integer;
begin
  t:='';
  for i:=1 to n do t:=t+s;
  rep:=t
end;

function leftpad(s:string; n:byte):string;
{ pads a string < length n with spaces on the left to make length n }
begin
  if length(s)>=n then leftpad:=s
  else leftpad:=rep(' ',n-length(s))+s
end;

procedure reverse(var s:string);
var
  t: string;
  l,i: integer;
begin
  l:=length(s);
  t:=s;
  for i:=l downto 1 do t[l+1-i]:=s[i];
  s:=t
end;

procedure spacechop(var s:string);
{ chops leading and trailing spaces from s }
begin
  while (length(s)>0) and (s[1]=' ') do delete(s,1,1);
  while (length(s)>0) and (s[length(s)]=' ') do delete(s,length(s),1);
end;

end.