unit strings;

{ Written by William C. Thompson }

{ This unit was written to do a few basic things with strings }

interface

function allup(s:string):string;
function lowcase(c:char):char;
function alllow(s:string):string;
function rep(s:string; n:integer):string;
procedure reverse(var s:string);

implementation

function allup(s:string):string;
var i:byte;
begin
  for i:=1 to length(s) do s[i]:=upcase(s[i]);
  allup:=s
end;

function lowcase(c:char):char;
begin
  if c in ['A'..'Z'] then c:=chr(ord(c)+32);
  lowcase:=c
end;

function alllow(s:string):string;
var i:byte;
begin
  for i:=1 to length(s) do s[i]:=lowcase(s[i]);
  alllow:=s
end;

function rep(s:string; n:integer):string;
var
  t: string;
  i: integer;
begin
  t:='';
  for i:=1 to n do t:=t+s;
  rep:=t
end;

procedure reverse(var s:string);
var
  t: string;
  l,i: integer;
begin
  l:=length(s);
  t:=s;
  for i:=l downto 1 do t[l+1-i]:=s[i];
  s:=t
end;

end.