
#define Uses_TEventQueue
#define Uses_TEvent
#define Uses_TProgram
#define Uses_TApplication
#define Uses_TKeys
#define Uses_TRect
#define Uses_TMenuBar
#define Uses_TSubMenu
#define Uses_TMenuItem
#define Uses_TStatusLine
#define Uses_TStatusItem
#define Uses_TStatusDef
#define Uses_TDeskTop
#define Uses_TView
#define Uses_TWindow
#define Uses_TFrame
#define Uses_TScroller
#define Uses_TScrollBar
#define Uses_TDialog
#define Uses_TButton
#define Uses_TSItem
#define Uses_TCheckBoxes
#define Uses_TRadioButtons
#define Uses_TLabel
#define Uses_TInputLine
#define Uses_TCollection
#define Uses_THistory
#define Uses_THistoryWindow
#define Uses_TListBox
#define Uses_TStringCollection
#define Uses_TMemo
#define Uses_TColoredText
#define Uses_TInputLong
#define Uses_fpstream
#define Uses_MsgBox
#define Uses_TResourceCollection
#define Uses_TResourceFile
#include <tv.h>
#include <stdlib.h>
#include <dos.h>
#include <dir.h>
#include <fcntl.h>
#include <string.h>
#include <stdio.h>
#include <new.h>
#include "tinplong.h"
#include "tcolortx.h"
#include "readscpt.h"

__link(RView);
__link(RDialog);
__link(RResourceCollection);
__link(RButton);
__link(RCluster);
__link(RCheckBoxes);
__link(RRadioButtons);
__link(RLabel);
__link(RStaticText);
__link(RScrollBar);
__link(RInputLine);
__link(RHistory);
__link(RListBox);
__link(RMemo);
__link(RInputLong);
__link(RColoredText);

TDialog *dlg;   //hold the dialog as it is built up
TView *control;
TScrollBar *hScrollBar;

//the following extend the ViewObj struct's to also write the code
struct DialogResourceObj : DialogObj {
     virtual void writeCode();
     };
struct ButtonResourceObj : ButtonObj {
     virtual void writeCode();
     };
struct InputLongResourceObj : InputLongObj {
     virtual void writeCode();
     };
struct LabelResourceObj : LabelObj {
     virtual void writeCode();
     };
struct HistoryResourceObj : HistoryObj {
     virtual void writeCode();
     };
struct InputLineResourceObj : InputLineObj {
     virtual void writeCode();
     };
struct ClusterResourceObj : ClusterObj {
     virtual void writeCode();
     };
struct ListBoxResourceObj : ListBoxObj {
     virtual void writeCode();
     };
struct ScrollBarResourceObj : ScrollBarObj {
     virtual void writeCode();
     };
struct MemoResourceObj : MemoObj {
     virtual void writeCode();
     };
struct StaticTextResourceObj : StaticTextObj {
     virtual void writeCode();
     };
struct ColoredTextResourceObj : ColoredTextObj {
     virtual void writeCode();
     };

char* convert(char *s)
// converts the strings (which are meant to be quoted ascii strings) to
// string suitable for input without quotes.  \n (two chars) is converted
// to newline, \" (two chars) is converted to single ", etc.
{
 static char rslt[300];
 char *d = rslt, c = *s++;
 while( c )  {
   if (c == '\\') {
       if (*s == '\\') {*d++ = '\\'; s++;}
       else if (*s == 'n') {*d++ = '\n'; s++;}
       else if (*s == '"') {*d++ = '"'; s++;}
      }
   else *d++ = c;
   c = *s++;
   }
 *d = '\0';
 rslt[254] = '\0';  //this is max string len for TStaticText!
 return rslt;
}

void reportError(const char* s)
{
 cout << s << endl;
 exit(1);
}

void doOptionsEtc(TView *P, ViewObj *V)
{
 P->options = V->Optns;
 P->eventMask = V->EvMsk;
 P->helpCtx = V->HCtx;
 P->growMode = V->Grow;
}

void DialogResourceObj::writeCode()
{
 dlg = new TDialog(TRect(X1, Y1, X2, Y2), convert(Title));
 if (dlg) {
   doOptionsEtc(dlg, this);
   dlg->palette = Palette;
   dlg->flags = WinFlags;
   }
 else reportError("Cannot construct TDialog");
}

void ButtonResourceObj::writeCode()
{
 control = new TButton(TRect(X1, Y1, X2, Y2), convert(ButtonText),
               CommandValue, Flags);
 if (control) {
   doOptionsEtc(control, this);
   dlg->insert(control);
   }
 else reportError("Cannot construct TButton");
}

void InputLongResourceObj::writeCode()
{
 control = new TInputLong(TRect(X1, Y1, X2, Y2), LongStrLeng, LLim, ULim,
                                    ILOptions, convert(LongLabelText));
 if (control) {
   doOptionsEtc(control, this);
   dlg->insert(control);
   }
 else reportError("Cannot construct TInputLong");
}

void InputLineResourceObj::writeCode()
{
 control = new TInputLine(TRect(X1, Y1, X2, Y2), StringLeng);
 if (control) {
   doOptionsEtc(control, this);
   dlg->insert(control);
   }
 else reportError("Cannot construct TInputLine");
}

void StaticTextResourceObj::writeCode()
{
 control = new TStaticText(TRect(X1, Y1, X2, Y2), convert(Text));
 if (control) {
   doOptionsEtc(control, this);
   dlg->insert(control);
   }
 else reportError("Cannot construct TStaticText");
}

void ColoredTextResourceObj::writeCode()
{
 control = new TColoredText(TRect(X1, Y1, X2, Y2), convert(Text), Attrib);
 if (control) {
   doOptionsEtc(control, this);
   dlg->insert(control);
   }
 else reportError("Cannot construct TColoredText");
}

void ScrollBarResourceObj::writeCode()
{
 TScrollBar *tmp = new TScrollBar(TRect(X1, Y1, X2, Y2));
 if (tmp) {
   doOptionsEtc(tmp, this);
   dlg->insert(tmp);
   if (stricmp(VarName, "hscroll") == 0)
     hScrollBar = tmp;     // probably a horizontal scroll bar for TMemo
   else control = tmp;
   }
 else reportError("Cannot construct TScrollBar");
}

void ListBoxResourceObj::writeCode()
{
 TScrollBar *scroll = 0;
 if (ScrollBar != 0)
   scroll = (TScrollBar*)control;

 control = new TListBox(TRect(X1, Y1, X2, Y2), Columns, scroll);
 if (control) {
   doOptionsEtc(control, this);
   dlg->insert(control);
   }
 else reportError("Cannot construct TListBox");
}

void MemoResourceObj::writeCode()
{
 TScrollBar *vbar = 0, *hbar = 0;
 if (VScroll != 0)
   vbar = (TScrollBar*)control;
 if (HScroll != 0)
   hbar = hScrollBar;

 control = new TMemo(TRect(X1, Y1, X2, Y2), hbar, vbar, 0, BufSize);
 if (control) {
   doOptionsEtc(control, this);
   dlg->insert(control);
   }
 else reportError("Cannot construct TMemo");
}

void formTSItem(void *p, void* l)
{char *s = (char*)p;
 TSItem *last = new TSItem(newStr(convert(s)), *(TSItem**)l);
 *(TSItem**)l = last;
}

void ClusterResourceObj::writeCode()
{
 TSItem *lastItem = 0;
// LabelColl->forEach(&formTSItem, &lastItem);

  for (int i=Items-1; i >= 0; i--) {     //must do this one backwards
    char *s = (char *)LabelColl->at(i);
    lastItem = new TSItem(convert(s), lastItem);
    }

if (strcmp(Obj, "TCheckBoxes") == 0)
     control = new TCheckBoxes(TRect(X1, Y1, X2, Y2), lastItem);
 else if (strcmp(Obj, "TRadioButtons") == 0)
     control = new TRadioButtons(TRect(X1, Y1, X2, Y2), lastItem);
 else control = 0;

 if (control) {
   doOptionsEtc(control, this);
   dlg->insert(control);
   }
 else {
   cout << "Cannot construct " << Obj << endl;
   exit(1);
   }
}

void LabelResourceObj::writeCode()
{
 TLabel *labl = new TLabel(TRect(X1, Y1, X2, Y2), convert(LabelText), control);
 if (labl) {
   doOptionsEtc(labl, this);
   dlg->insert(labl);
   }
 else reportError("Cannot construct TLabel");
}

void HistoryResourceObj::writeCode()
{
 THistory *history = new THistory(TRect(X1, Y1, X2, Y2), (TInputLine*)control,
                      HistoryID);
 if (history) {
   doOptionsEtc(history, this);
   dlg->insert(history);
   }
 else reportError("Cannot construct THistory");
}

//now that we know the final extensions of ViewObj, we can write the
//getKind function
ViewObj *getKind(recType Kind)
{ ViewObj *P;
  switch (Kind) {
      case Dlg : P = new DialogResourceObj(); break;
      case Button : P = new ButtonResourceObj(); break;
      case InputL : P = new InputLineResourceObj(); break;
      case Labl : P = new LabelResourceObj();  break;
      case Histry : P = new HistoryResourceObj(); break;
      case ILong : P = new InputLongResourceObj(); break;
      case CheckB: P = new ClusterResourceObj(); break;
      case RadioB: P = new ClusterResourceObj(); break;
      case MultiCB: P = new MultiCheckBoxObj(); break;
      case ListB: P = new ListBoxResourceObj(); break;
      case ScrollB :  P = new ScrollBarResourceObj(); break;
      case Memo: P = new MemoResourceObj(); break;
      case SText: P = new StaticTextResourceObj(); break;
      case CText : P = new ColoredTextResourceObj(); break;
      default : P = 0; break;
      }
return P;
}

void DoControls(void *p, void*)
{ViewObj *P = (ViewObj*)p;
 checkMemory();
 P->writeCode();
}

void makeDialog()
{
 Dialog->writeCode();
 ScriptColl->forEach(&DoControls, 0);
 dlg->selectNext(False);
}

int Copy(char* from, char* to)  //copy one file to another
{int h1, h2;
 unsigned numRead, numWritten;
 char buf[1000];
 if (!(_dos_open(from, O_RDONLY, &h1) == 0)) return 0;
 if (!(_dos_creat(to, _A_NORMAL, &h2) == 0)) return 0;
 do  {
   _dos_read(h1, buf, 1000, &numRead);
   _dos_write(h2, buf, numRead, &numWritten);
   }
 while (numRead > 0 && numWritten == numRead);
 _dos_close(h1);
 _dos_close(h2);
 return numWritten == numRead;
}

#define TNAME "TMP$$.$$$"

void writeResource(char* fname, char* id)
{
 makeDialog();   //dialog is not pointed to by 'dlg'

 struct ffblk ffblk;
 char backName[MAXPATH];
 char drive[MAXDRIVE];
 char dir[MAXDIR];
 char name[MAXFILE];

 if (findfirst(fname, &ffblk, 0) == 0) {   //the file exists already
   if (!Copy(fname, TNAME)) {      //copy so we can backup the original
     cout << "Copying original file failed\n";
     exit(1);
     }
   fnsplit(fname, drive, dir, name, 0);
   fnmerge(backName, drive, dir, name, ".BAK");
   remove(backName);              //in case a .BAK file already exists
   if (rename(fname, backName) != 0) {
     cout << "Renaming original file failed\n";
     exit(1);
     }
   if (rename(TNAME, fname) != 0) {
     cout << "Renaming temporary file failed\n";
     exit(1);
     }
   }

 fpstream *ifps;
 ifps = new fpstream(fname, ios::out|ios::binary|ios::ate|ios::in);
 ifps->seekg(0);
 if (!ifps->good()) {
   cout << "Error opening " << fname << endl;
   exit(1);
   }

 TResourceFile *myRez;
 myRez = new TResourceFile( ifps);
 if (!myRez) {
   cout << "Resource file constructor failed\n";
   exit(1);
   }

 myRez->put(dlg, id);
 if (ifps->fail())  {
   cout << "Dialog put failed\n";
   exit(1);
   }

 TObject::destroy(dlg);
 TObject::destroy(myRez);
}

//-------------------------------------------------------------------
// The following exit procedure is required in order to view error
// messages before Turbo Vision wipes out the screen
//-------------------------------------------------------------------
int exit_flag = 1;

void exitfunc(void)
{
  if( exit_flag )
  {
     cout << "\nStrike Enter key to continue" << endl;
     char c;
     cin.get(c);
  }
}

#pragma exit exitfunc  100

int main(int argc, char** argv)
// argv[1] is script filename
// argv[2] is resource filename
// argv[3] is resource ID
// argv[4] is error filename

{
 if (argc < 3) {
   cout << "Usage: cpprsrc <script filename> <RezFilename> <RezID> [error filename]";
   exit(1);
   }

 if (argc > 4) {   // redirect stdout to the error file
   freopen(argv[4], "w", stdout);
   exit_flag = 0;   // won't need hold up on exit
   }

 checkMemory();

 readScriptFile(argv[1]);  //argv(1) is temporary script file

 writeResource(argv[2], argv[3]);

 cout << "completed" << endl;
 return 0;
}
