#define Uses_TStringCollection
#include <tv.h>
#include <stdlib.h>
#include <dos.h>
#include <dir.h>
#include <fcntl.h>
#include <string.h>
#include <iostream.h>
#include <fstream.h>
#include <stdio.h>
#include "readscpt.h"

ofstream outf;
char DlgName[50];   //holds the dialog varible name for easy access
Boolean needcontrol1;  //set if need control1 variable name

char* quoted(const char* s)
//returns a double quoted string or "0" for empty string
{
 static char q[300] = {"\""};   //the first quote in place
 if (*s == '\0' || !s) return "0";
 strcpy(&q[1], s);
 short l = strlen(q);
 q[l] = '\"';
 q[l+1] = '\0';
 return q;
}

void aField(ViewObj *P, char* fieldtype)
{
 outf << "  " << fieldtype << " " << P->FieldName << ";   //" << P->Obj <<endl;
}

void aVar(ViewObj *P)
{
 if (strcmp(P->VarName, "control") != 0)
   outf << P->Obj << " *" << P->VarName << ";\n";
}

//the following extend the ViewObj struct's to also write the code
struct DialogWriteObj : DialogObj {
     virtual void writeCode();
     };

struct ButtonWriteObj : ButtonObj {
     virtual void writeCode();
     virtual void writeVars() {aVar(this);};
     };

struct InputLongWriteObj : InputLongObj {
     virtual void writeCode();
     virtual void writeFields() {aField(this, "long");} ;
     virtual void writeVars() {aVar(this);};
     };
struct LabelWriteObj : LabelObj {
     virtual void writeCode();
     };
struct HistoryWriteObj : HistoryObj {
     virtual void writeCode();
     };
struct InputLineWriteObj : InputLineObj {
     virtual void writeCode();
     virtual void writeFields();
     virtual void writeVars() {aVar(this);};
     };
struct ClusterWriteObj : ClusterObj {
     virtual void writeCode();
     virtual void writeFields() {aField(this, "ushort");} ;
     virtual void writeVars() {aVar(this);};
     };
struct ListBoxWriteObj : ListBoxObj {
     virtual void writeCode();
     virtual void writeFields() {aField(this, "TListBoxRec");} ;
     virtual void writeVars() {aVar(this);};
     };
struct ScrollBarWriteObj : ScrollBarObj {
     virtual void writeCode();
     virtual void writeVars();
     };
struct MemoWriteObj : MemoObj {
     virtual void writeCode();
     virtual void writeFields();
     virtual void writeVars() {aVar(this);};
     };
struct StaticTextWriteObj : StaticTextObj {
     virtual void writeCode();
     virtual void writeVars() {aVar(this);};
     };
struct ColoredTextWriteObj : ColoredTextObj {
     virtual void writeCode();
     virtual void writeVars() {aVar(this);};
     };


//now that we know the final extensions of ViewObj, we can write the
//getKind function
ViewObj *getKind(recType Kind)
{ ViewObj *P;
  switch (Kind) {
      case Dlg : P = new DialogWriteObj(); break;
      case Button : P = new ButtonWriteObj(); break;
      case InputL : P = new InputLineWriteObj(); break;
      case Labl : P = new LabelWriteObj();  break;
      case Histry : P = new HistoryWriteObj(); break;
      case ILong : P = new InputLongWriteObj(); break;
      case CheckB: P = new ClusterWriteObj(); break;
      case RadioB: P = new ClusterWriteObj(); break;
      case MultiCB: P = new MultiCheckBoxObj(); break;
      case ListB: P = new ListBoxWriteObj(); break;
      case ScrollB :  P = new ScrollBarWriteObj(); break;
      case Memo: P = new MemoWriteObj(); break;
      case SText: P = new StaticTextWriteObj(); break;
      case CText : P = new ColoredTextWriteObj(); break;
      default : P = 0; break;
      }
return P;
}

char * getWinFlagWords(ushort w, char *s)
//given the set bits return names in 'or' form
{
 static char *flagArray[4] =  {
        "wfMove", "wfGrow", "wfClose", "wfZoom"};
 s[0] = '\0';
 for (int i = 0; i <= 15; i++) {
   if ((w & 1) == 1 && flagArray[i][0] != '\0')
     strcat(strcat(s, flagArray[i]), " | ");
   w >>= 1;
   }
 int l = strlen(s);
 if (l > 4)
    s[l-3] = '\0';   //remove last " | "
 return s;
}

char * getEventWords(ushort w, char *s)
//given the set bits return names in 'or' form
{
 static char *flagArray[10] =  {
        "evMouseDown", "evMouseUp", "evMouseMove", "evMouseAuto",
        "evKeyDown", "", "", "", "evCommand", "evBroadcast"};
 s[0] = '\0';
 for (int i = 0; i <= 15; i++) {
   if ((w & 1) == 1 && flagArray[i][0] != '\0')
     strcat(strcat(s, flagArray[i]), " | ");
   w >>= 1;
   }
 int l = strlen(s);
 if (l > 4)
    s[l-3] = '\0';   //remove last " | "
 return s;
}

char * getOptionWords(ushort w, char *s)
//given the set bits return names in 'or' form
{
 static char *flagArray[16] =  {
        "ofSelectable", "ofTopSelect", "ofFirstClick", "ofFramed",
        "ofPreProcess", "ofPostProcess", "ofBuffered", "ofTileable",
        "ofCenterX", "ofCenterY", "ofValidate", "0x800", "0x1000",
        "0x2000", "0x4000", "ofShoehorn"};
 s[0] = '\0';
 for (int i = 0; i <= 15; i++) {
   if ((w & 1) == 1 && flagArray[i][0] != '\0')
     strcat(strcat(s, flagArray[i]), " | ");
   w >>= 1;
   }
 int l = strlen(s);
 if (l > 4)
    s[l-3] = '\0';   //remove last " | "
 return s;
}

short bitCount(ushort w) //numbers of set bits in the word
{
 short count = 0;
 for (int i = 0; i <= 15; i++)  {
    if ((w & 1) == 1)
       count++;
    w >>= 1;
    }
return count;
}

void doBitOutput(const char* var, const char* pre, ushort actual,
                       ushort defaul, char* (func)(ushort w, char* s))
//output something like "foo->options |= ofSelectable or ofFramed;"
//and/or "foo-> options &= ofTopSelect;"
//actual is the bits set and defaul are the default settings
//it's known that actual and defaul are not equal on entry
{
 char s[100];
 ushort NOTs, ORs, diff ;
 diff = actual ^ defaul;  //the bits that are different
 if (bitCount(diff) > 5) { //this is too complex--output hex number
   outf << var << pre << " = 0x" << hex << actual << dec <<";\n";
   return;
   }
 NOTs = diff & defaul;  //the bits not in defaul
 ORs = diff & actual;    //the extra bits in actual
 s[0] = '\0';
 if (NOTs != 0) {
   outf << var <<pre;
   if (bitCount(NOTs) == 1)
     outf << " &= ~" << func(NOTs, s) << ";\n";
   else
     outf << " &= ~(" << func(NOTs, s) << ");\n";
   }
 s[0] = '\0';
 if (ORs != 0)
   outf << var << pre << " |= " << func(ORs, s) << ";\n";
}

void doTRect(ViewObj *P)
{
outf << "(TRect(" << P->X1 << ", " << P->Y1 << ", "
     << P->X2 << ", " << P->Y2 << ")";
}

void insertControl(const char *Name)
{
 outf <<  DlgName << "->insert(" << Name << ");\n\n";
}

void doOpEvent(ViewObj *P)
{if (P->DefEvMsk != P->EvMsk)
   doBitOutput(P->VarName, "->eventMask", P->EvMsk, P->DefEvMsk, getEventWords);

if (P->DefOptns != P->Optns)
   doBitOutput(P->VarName, "->options", P->Optns, P->DefOptns, getOptionWords);
}

void writeHelpCtx(char * VarName, char* H, ushort Ctx)
{
if (*H != '\0') {
  if (strcmp(H, "hcNoContext")) {
    outf << VarName << "->helpCtx = " << H << ";\n";
    }
  }
else if (Ctx != 0) {
    outf << VarName << "->helpCtx = " << Ctx << ";\n";
    }
}

void start(ViewObj *P)
{
  outf << P->VarName << " = new " << P->Obj;
  doTRect(P);
}

void finish(ViewObj *P)
{
  writeHelpCtx(P->VarName, P->HelpCtxSym, P->HCtx);
 doOpEvent(P);
 insertControl(P->VarName);
}

void DoControls(void *p, void*)
{ViewObj *P = (ViewObj*)p;
 P->writeCode();
}

void DialogWriteObj::writeCode()
{
  strncpy(DlgName, VarName, 49);

  outf << Obj << "* " << DlgFuncName << "(void)\n{\n";
  outf << "TView *control";
  if (needcontrol1) outf << ", *control1;\n";
  else outf << ";\n";

  outf << Obj << "* " << VarName << " = new " << Obj;
  doTRect(this);
  outf << ", " << quoted(Title) << ");\n";
  outf << "if (!" << VarName << ") return 0;\n\n";

  doOpEvent(Dialog);
  if (WinFlags != 5)    //5 is the default
     doBitOutput(VarName, "->flags", WinFlags, 5, getWinFlagWords);
  writeHelpCtx(VarName, HelpCtxSym, HCtx);
  outf << endl;

  ScriptColl->forEach(DoControls, 0);  //write code for each control

  outf << VarName << "->selectNext(False);\nreturn " << VarName << ";\n}\n";
}

void flagsOut(ushort flags)    //used by TButton
{
 if (flags == 0) outf << "bfNormal";
 else {
    short plus = 0;
    if ((flags & 1) != 0) {
        plus = 1; outf << "bfDefault"; }
    if ((flags & 2) != 0) {
        if (plus) outf << "|";
        plus = 1;
        outf << "bfLeftJust";}
    if ((flags & 4) != 0) {
        if (plus) outf << "|";
        plus = 1;
        outf << "bfBroadcast"; }
    if ((flags & 8) != 0)  {
        if (plus) outf << "|";
        outf << "bfGrabFocus"; }
    }
}

void ButtonWriteObj::writeCode()
{
 start(this);
 if (strcmp("POptionButton", Obj) == 0)  //special POptionButton
    outf << ", " << Param[0] << ", " << Param[1] << ");\n";
 else {                                 // normal TButton
    outf << ", " << quoted(ButtonText) << ", ";
    if (*CommandName != '\0')
       outf << CommandName;
    else outf << CommandValue;
    outf << ", ";
    flagsOut(Flags);
    outf << ");\n";
    }
 finish(this);
}

void LabelWriteObj::writeCode()
{
 outf << "  " << DlgName << "->insert(new " << Obj;
 doTRect(this);
 outf << ", " << quoted(LabelText) << ", " << LinkName << "));\n\n";
}

void HistoryWriteObj::writeCode()
{
 outf << "  " << DlgName << "->insert(new " << Obj;
 doTRect(this);
 outf << ", (TInputLine*)" << HistoryLink << ", " << HistoryID << "));\n\n";
}

void InputLongWriteObj::writeCode()
{
  start(this);
  outf << ", " << (LongStrLeng+1) << ", " << LLim << ", " << ULim <<  ", "
       << ILOptions << ", " << quoted(LongLabelText) << ");\n";
  finish(this);
}

void InputLineWriteObj::writeCode()
{
  outf << VarName << " = new " << Obj;
  doTRect(this);
  outf << ", " << (StringLeng+1) << ");\n";    //Note: add 1
  finish(this);
}
void InputLineWriteObj::writeFields()
{
  outf << "  char " << FieldName << "[" << (StringLeng+1)  //Note: add 1 !
       << "];   //" << Obj << endl;
}

void doText(char *s)
{    //split up a long string into several lines. String cannot exceed 254
 if (!*s) {
   outf << 0;
   return;
   }
 if (strlen(s) > 254) s[254] = '\0';   //truncate if too big
 outf << '\"';
 short count = 47;
 while (*s)  {
    if (s[0] == '\\' && s[1] == 'n' && s[2]) {
       outf << s[0] << s[1] << "\"\n     \"";
       count = 5;
       s++;    //extra increment to pass 'n'
       }
    else {
       outf << *s;
       count++;
       }
    s++;
    if (count > 75 && *s) {
       outf << "\"\n     \"";
       count = 5;
       }
    }
 outf << '\"';
}

void StaticTextWriteObj::writeCode()
{
  start(this);
  outf << ", ";
  doText(Text);
  outf << ");\n";
  finish(this);
}

void ColoredTextWriteObj::writeCode()
{
  start(this);
  outf << ", ";
  doText(Text);
  outf << ", 0x" << hex << Attrib << dec << ");\n";
  finish(this);
}

void ScrollBarWriteObj::writeCode()
{
  start(this);
  outf << ");\n";
  finish(this);
}

void ScrollBarWriteObj::writeVars()
{
 if (strcmp(VarName, "control1") != 0) //control1 is used by TMemo
   aVar(this);
 else needcontrol1 = True;
}

void ListBoxWriteObj::writeCode()
{
  start(this);
  outf << ", " << Columns << ", ";
  if (*ScrollBar != '\0')
    outf << "(TScrollBar*)" << ScrollBar << ");\n";
  else outf << "0);\n";
  finish(this);
}

void MemoWriteObj::writeCode()
{
  start(this);
  outf << ", " ;
  if (*HScroll != '\0')
    outf << "(TScrollBar*)" << HScroll << ", ";
  else outf << "0, ";
  if (*VScroll != '\0')
    outf << "(TScrollBar*)" << VScroll << ", 0, ";
  else outf << "0, 0, ";
  outf << BufSize << ");\n";
  finish(this);
}
void MemoWriteObj::writeFields()
{
  outf << "  ushort " << FieldName << ";   //" << Obj << " text length\n";
  outf << "  char " << TextFieldName << "[" << BufSize << "];   //"
       << Obj << " text\n";
}

void ClusterWriteObj::writeCode()
{
  start(this);
  for (int i=0; i < Items; i++)
    outf << ",\n  new TSItem(\"" << (char *)LabelColl->at(i) << "\"";
  outf << ", 0";
  for (i = 0; i <= Items; i++)
    outf << ")";
  outf << ";\n";
  finish(this);
}

void doVars(void *p, void*)
{ViewObj *P = (ViewObj*)p;
 P->writeVars();
}

void chkFirst(int& first)  //called by doFields
{
 if ( first ) {
    outf << "struct " << Dialog->FieldName << "  {\n";
    first = False;
    }
}

void doFields(void *p, void* first)
{     // fieldnames for the data transfer struct
 ViewObj *P = (ViewObj*)p;
 if ( *(P->FieldName) != '\0') {
    chkFirst( *(int*)first );
    P->writeFields();
    }
 else if (strcmp("POptionButton", P->Obj) == 0) { //special POptionButton
    chkFirst( *(int*)first );
    outf << "  OptionRec " << P->Param[2] <<  ";   //POptionButton\n";
    }
}

void writeSource()
{//code to build the data transfer struct
 int first = True;
 ScriptColl->forEach(doFields, &first);
 if (!first) outf << "  };\n\n";  //if !first, there is at least one field

 //define variables whose names are not "control"
 ScriptColl->forEach(doVars, 0);
 outf << endl;

 //the code for the dialog and its controls
 Dialog->writeCode();
}

//-------------------------------------------------------------------
// The following exit procedure is required in order to view error
// messages before Turbo Vision wipes out the screen
//-------------------------------------------------------------------
int exit_flag = 1;

void exitfunc(void)
{
  if( exit_flag )
  {
     cout << "\nStrike Enter key to continue" << endl;
     char c;
     cin.get(c);
  }
}

#pragma exit exitfunc  100

int main(int argc, char** argv)
// argv[1] is script file
// argv[2] is .src name
// argv[3] is error filename

{
 if (argc < 3) {
   cout << "Usage:  custom1 <script filename> <source filename> [error filename]";
   exit(1);
   }
 if (argc >= 4) {
   freopen(argv[3], "w", stdout);  //redirect output to error file
   exit_flag = 0;   // won't need hold up on exit
   }

 checkMemory();

 readScriptFile(argv[1]);  //argv(1) is temporary script file

 outf.open(argv[2], ios::out);
 if (!outf.good())
   cout << "Can't open source file" << endl;

 writeSource();
 outf.close();
 cout << "completed" << endl;
 return 0;
}
