/*  Copyright (C) 1993   Marc Stern  (internet: stern@mble.philips.be)  */

#define Uses_TButton
#define Uses_TRect
#define Uses_TWindow
#define Uses_MsgBox

#include "tvtools.h"


/***
 *
 *  Function   :    TwoButtons
 *
 *  Topics     :    Insert 2 buttons in a view.
 *
 *  Decisions  :    Insertion in the middle of the bottom of the view.
 *                  OK button is default one.
 *
 *  Parameters :    in          TWindow *window
 *                  in          int type     ( 0 = OK/Cancel, 1 = Yes/No )
 *
 *  Return     :    none
 *
 ***/


void TwoButtons( TWindow *window, int type )

{ const y = window->size.y - 3;
  const buttonLen = 10;

  const char *label[] = { MsgBoxText::okText, MsgBoxText::yesText, MsgBoxText::cancelText, MsgBoxText::noText };

  ushort offset = ( window->size.x > 2 * buttonLen + 6 ) ? 3 : 1;

  ushort x = window->size.x / 2 - buttonLen - offset;
  window->insert( new TButton(TRect(x, y, x + buttonLen, y + 2),
                              label[type], cmOK, bfDefault
                             )
                );

  x = window->size.x / 2 + offset;
  window->insert( new TButton(TRect(x, y, x + buttonLen, y + 2),
                              label[type + 2], cmCancel, bfNormal
                             )
                );
}
