/*-------------------------------------------------------------------*/
/*                                                                   */
/*   Heap.cpp:  Heap for the Turbo Vision Demo.                      */
/*              Display the current heap space at the right end      */
/*              of the status line.                                  */
/*-------------------------------------------------------------------*/


#define Uses_TApplication
#define Uses_THeapView
#include "tvtools.h"

#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include <strstrea.h>
#include <iomanip.h>
#include <alloc.h>



//
// ------------- Heap Viewer functions
//

THeapView::THeapView( TRect& r ) : TView( r )
{
  if ( ! size.x )
     {
       TRect r = TApplication::application->getExtent();
       r.a.x = r.b.x - 7; r.a.y = r.b.y - 1;
       growMode = gfGrowAll;
       moveTo( r.a.x, r.a.y );
       growTo( r.b.x, r.b.y );
       growMode = 0;
     }

  oldMem = 0;
  newMem = heapSize();
}


void THeapView::draw()
{
    TDrawBuffer buf;
    char c = getColor(2);

    buf.moveChar( 0, ' ', c, size.x );
    buf.moveStr( 0, heapStr, c );
    writeLine( 0, 0, size.x, 1, buf );
}


void THeapView::update()
{
    if ( (newMem = heapSize()) != oldMem )
       {
         oldMem = newMem;
         drawView();
       }
}


long THeapView::heapSize()
{
  long total = farcoreleft();
  struct farheapinfo heap;
  ostrstream totalStr( heapStr, sizeof heapStr );

  switch( farheapcheck() )
        {
          case _HEAPEMPTY  : strcpy(heapStr, " No heap");
                             total = -1;
                             break;

          case _HEAPCORRUPT: strcpy(heapStr, " Corrupt");
                             total = -2;
                             break;

          case _HEAPOK     : heap.ptr = NULL;
                             while ( farheapwalk(&heap) != _HEAPEND )
                                   if ( ! heap.in_use ) total += heap.size;
                             totalStr << setw(7) << total << ends;
                             break;
        }

  return total;
}
