/*  Copyright (C) 1993   Marc Stern  (internet: stern@mble.philips.be)  */

#define Uses_TStreamable
#define Uses_MsgBox
#define Uses_TInputDouble
#include "tvtools.h"
__link( RInputLine )


#include <string.h>
#include <stdio.h>
#include <values.h>
#include <stdlib.h>
#include <strstream.h>




// TInputDouble

const char * const TInputDouble::name = "TInputDouble";

void TInputDouble::write( opstream& os )
{
  TInputLine::write( os );
  os << min;
  os << max;
}

void *TInputDouble::read( ipstream& is )
{
  TInputLine::read( is );
  is >> min;
  is >> max;
  return this;
}

TStreamable *TInputDouble::build()
{
  return new TInputDouble( streamableInit );
}


TStreamableClass RInputDouble( TInputDouble::name,
                               TInputDouble::build,
                               __DELTA(TInputDouble)
                             );

TInputDouble::TInputDouble( const TRect& bounds,
			    int aMaxLen,
			    double aMin,
			    double aMax
                          )
             :TInputRegExp( bounds, aMaxLen, "-.0-9" )
{
  min = aMin;
  max = aMax;
}

TInputDouble::TInputDouble( int x, int y,
			    int aMaxLen,
			    double aMin,
			    double aMax
                          )
             :TInputRegExp( x, y, aMaxLen, "-.0-9" )
{
  min = aMin;
  max = aMax;
}


ushort TInputDouble::dataSize()
{
  return sizeof( double );
}

void TInputDouble::getData( void *rec )
{
  *(double *)rec = atof( data );
}

void TInputDouble::setData( void *rec )
{
  gcvt( *(double *)rec, MAXINT, data );
  selectAll(True);
}

Boolean TInputDouble::valid( ushort command )
{
  switch( command )
        {
          case cmReleasedFocus: return True;

          case cmQuit :
          case cmClose:
          case cmOK   : if ( ! *data ) strcpy( data, "0" );
                        double value = atof( data );
                        if ( (value < min) || (value > max) || (! value && *data) )
                           {
                             select();
                             messageBox( mfError | mfOKButton,
                                         "\03Number must be between %f and %f.",
                                         min, max
                                       );
                             selectAll( True );
                             return False;
                           }
                        break;
        }

  return TInputRegExp::valid( command );
}
