/*  Copyright (C) 1993   Marc Stern  (internet: stern@mble.philips.be)  */

#define Uses_TStreamable
#define Uses_MsgBox
#define Uses_TInputKey
#include "tvtools.h"
__link( RInputLine )


#include <string.h>
#include <stdio.h>
#include <values.h>
#include <stdlib.h>
#include <strstream.h>


// TInputKey

const char *const TInputKey::name = "TInputKey";

TStreamable *TInputKey::build()
{
  return new TInputKey( streamableInit );
}

TInputKey::TInputKey( const TRect& bounds, int aMaxLen )
          :TInputLine( bounds, aMaxLen )
{
}

TInputKey::TInputKey( int x, int y, int aMaxLen )
          :TInput1Line( x, y, aMaxLen )
{
}

TStreamableClass RInputKey( TInputKey::name,
                            TInputKey::build,
                            __DELTA(TInputKey)
                          );


Boolean TInputKey::valid( ushort command )
{
  switch( command )
        {
          case cmQuit :
          case cmClose:
          case cmOK   : if ( ! *data )
                           {
                             select();
                             messageBox( "\03This field cannot be empty.",
                                         mfError | mfOKButton
                                       );
                             return False;
                           }
                        break;
        }

  return TInputLine::valid(command);
}

