/*  Copyright (C) 1993   Marc Stern  (internet: stern@mble.philips.be)  */

#include <iostream.h>

#define Uses_otstream
#define Uses_TApplication
#define Uses_TDeskTop
#define Uses_TRect
#define Uses_TTerminal
#define Uses_TWindow
#define Uses_TOutErr
#include "tvtools.h"


class TOutputWindow : public TWindow
{
  TTerminal *_term;

public:

  TOutputWindow( TRect bounds, const char *title,
                 ostream_withassign& ostr, ushort bufsize
               );

  void attach( ostream_withassign& ostr )
             {
               // Attach TTerminal stream buffer to I/O stream.
               ostr = _term;
             }
};

TOutputWindow::TOutputWindow( TRect bounds, const char *title,
                              ostream_withassign& ostr, ushort bufsize
                            ) :
                              TWindowInit( &TOutputWindow::initFrame ),
                              TWindow( bounds, title, wnNoNumber )
{
  // Terminal view should cover entire window.
  bounds = getExtent();
  bounds.grow(-1, -1);

  // Create terminal view and add to window.
  _term = new TTerminal( bounds,
                         standardScrollBar(sbHorizontal | sbHandleKeyboard),
                         standardScrollBar(sbVertical | sbHandleKeyboard), 
                         bufsize
                       );
  insert( _term );

  // Create TV output stream and copy it;
  // normally attach( ostr ) would be sufficient.
  otstream ot( _term );
  ostr = ot;
}

TOutErr::TOutErr( TRect& outbounds, ushort outbufsize,
                  TRect& errbounds, ushort errbufsize
                ) :
                  TProgInit( &TOutErr::initStatusLine, &TOutErr::initMenuBar,
                             &TOutErr::initDeskTop
                           )
{
  // Save current I/O assignments.
  _old_cout = cout;
  _old_cerr = cerr;
  _old_clog = clog;

  TOutputWindow *tow;

  // Create standard output window.
  tow = new TOutputWindow( outbounds, "Standard Output", cout, outbufsize );
  deskTop->insert(tow);

  // Create standard error window and attach to log stream.
  tow = new TOutputWindow( errbounds, "Standard Error", cerr, errbufsize );
  tow->attach( clog );
  deskTop->insert( tow );
}

TOutErr::~TOutErr()
{
  // Restore old I/O assignments.
  cout = _old_cout;
  cerr = _old_cerr;
  clog = _old_clog;
}
