/*
 *	monochrome device driver
 */

#include "driver.h"

#define	VidSeg	0xB0000000	/*  addr of monochrome video RAM	*/
#define	Attr	0x0700		/*  video attribute mask		*/
#define	Blank	(Attr + ' ')	/*  a blank				*/

static BYTE	row,		/*  current row number			*/
		col;		/*  current column number		*/

static WORD far *VidAddr;	/*  -> current display character	*/


/********************************
 *	local routines		*
 *******************************/

/*
 *	set() ->	set WORDs
 */
static void set(addr, len, val)
	WORD far	*addr;
	int		 len;
	WORD		 val;
	{
	while (len--)
		*addr++ = val;
	}


/*
 *	copy() ->	copy WORDs
 */
static void copy(src, dst, len)
	WORD far	*src;
	WORD far	*dst;
	int		 len;
	{
	while (len--)
		*dst++ = *src++;
	}


/*
 *	cls() ->	clear the screen
 */
static void cls()
	{
	set(VidSeg, 2000, Blank);	/*  clear the screen  */

	row = col = 0;			/*  reset  */
	VidAddr = (WORD far *)VidSeg;
	}


/*
 *	ScrollUp() ->	scroll screen upwards
 */
static void ScrollUp()
	{
	copy(VidSeg + 160, VidSeg, 1920);	/*  move up  */

	set(VidSeg + 3840, 80, Blank);		/*  clear last line  */

	VidAddr -= 80;
	row = 24;
	}


/*
 *	LineFeed() ->	perform line-feed
 */
static void LineFeed()
	{
	VidAddr += 80;
	if (++row > 24)
		ScrollUp();
	}


/*
 *	Put() ->	write character to screen
 */
static void Put(c)
	BYTE	c;
	{
	*VidAddr++ = (Attr + c);

	if (++col > 79)
		{
		col = 0;
		LineFeed();
		}
	}


/********************************
 *	public routines		*
 *******************************/

/*
 *	Init() ->	initialize driver
 */
void Init()
	{
	cls();

	((InitParms *)&ReqHdr)->EndAddr = EndAddr();
	ReqHdr.Status = Done;
	}


/*
 *	Output() ->	write bytes
 */
void Output()
	{
	InOutParms	*iop;	/*  our pointer		*/
	BYTE far	*ta;	/*  -> transfer addr	*/
	WORD		ctr;	/*  byte count		*/
	BYTE		c;

	iop = (InOutParms *)&ReqHdr;
	ta = (BYTE far *)iop->Transfer;
	ctr = iop->Count;

	while (ctr--)
		{
		switch (c = *ta++)
			{
			case '\r' :
				VidAddr -= col;	/*  move ptr  */
				col = 0;
				break;

			case '\n' :
				LineFeed();
				break;

			case '\b' :
				if (col)
					{
					col--;
					VidAddr--;
					}
				break;

			case '\t' :
				do
					Put(' ');
				while (col & 7);
				break;

			case '\f' :
				cls();
				break;

			default :
				Put(c);
				break;
			}
		}

	ReqHdr.Status = Done;
	}


/*
 *	OutVerify() ->	output with verfiy
 */
void OutVerify()
	{
	Output();	/*  what can go wrong ??  */
	}


/*
 *	OutStatus() ->	return output status
 */
void OutStatus()
	{
	ReqHdr.Status = Done;	/*  always ready  */
	}


/*
 *	OutFlush() ->	flush output
 */
void OutFlush()
	{
	ReqHdr.Status = Done;	/*  always flushed  */
	}


/*
 *	END of mono.c
 */
