'FASCII replaces any ASCII code in a file with another, or deletes it
'
' $INCLUDE: 'qb.bi'

DECLARE FUNCTION exists (filename$)

DIM SHARED inregs AS RegTypeX, outregs AS RegTypeX
CONST YES = 1, NO = 0
  
	com$ = COMMAND$
	DIM arg$(10)
	FOR n = 1 TO 5: arg$(n) = "": NEXT
	length = LEN(com$)
	true = -1: false = 0: i = 1: num = 1: inword = true
	WHILE i <= length
		ch$ = MID$(com$, i, 1)
		IF ch$ <> " " THEN
			IF NOT inword THEN inword = true
			arg$(num) = arg$(num) + ch$
		ELSEIF inword THEN
			num = num + 1
			inword = false
		END IF
		i = i + 1
	WEND
	y = 1
	IF NOT arg$(1) = "" THEN GOTO BEGINNING
HELP:
	PRINT " "
	PRINT "FASCII replaces ASCII codes in a file. "
	PRINT "(c) 1990 David A. Wesson"
	PRINT " "
	PRINT "Syntax: FASCII  [d:]filename  oldcode  newcode"
	PRINT " where  filename = original file  [drive optional]      "
	PRINT "        oldcode  = old ASCII code to be replaced"
	PRINT "        newcode  = new ASCII code to be substituted"
	PRINT "                   (Leave blank to delete oldcode)"
	PRINT " "
	PRINT "Type    FASCII C  to review ASCII code chart."
	PRINT ""
	PRINT "NOTE: Lines may not be longer than 132 characters."
	PRINT "      This program makes a backup of the original file"
	PRINT "      named filename.OLD "
	END
BEGINNING:
	infile$ = UCASE$(arg$(1))
	IF infile$ = "C" THEN GOSUB ASCII
	IF exists(infile$) = NO THEN GOTO nofind
		OPEN infile$ FOR INPUT AS #1
	outfile$ = "temp"
	OPEN outfile$ FOR OUTPUT AS #2
	GOSUB filename
	oldfile$ = UCASE$(file$) + ".OLD"
	oldcode = VAL(arg$(2))
	newcode = VAL(arg$(3))
	IF oldcode = 0 THEN GOTO NOCODE
	IF NOT newcode = 0 THEN newcode = VAL(arg$(3))
	IF newcode = oldcode GOTO BADCODE
ROUTINE:
	a = oldcode
	b = newcode
	old$ = CHR$(a)
	IF b = 0 THEN new$ = "NOTHING" ELSE new$ = CHR$(b)
	COLOR 15: PRINT "FASCII "; : COLOR 7: PRINT "Fast ASCII code replacer "
	PRINT "Replacing "; old$; " with "; new$; " in "; infile$; ", creating "; oldfile$
	PRINT "Hit [Ctrl]+[Break] to terminate"
	PRINT "Starting time: "; TIME$
	PRINT "   Processing: ";
	z = 0
CYCLE:
	IF EOF(1) THEN GOTO FINISH
	LINE INPUT #1, l$
	z = z + 1
	strt = 1
	LOCATE , 15: PRINT z;
search:
	lfpos = INSTR(strt, l$, CHR$(a))
	IF lfpos < 1 THEN GOTO DUMP
	GOTO SPLIT
NEXTLOOK:
	 strt = lfpos + 1: GOTO search
SPLIT:
	 lpart$ = LEFT$(l$, lfpos - 1)
	 rpart$ = RIGHT$(l$, LEN(l$) - lfpos)
	 IF b > 0 THEN
		 s$ = lpart$ + CHR$(b) + rpart$
	 ELSE s$ = lpart$ + rpart$
	 END IF
	 l$ = s$
	 GOTO NEXTLOOK
NEWOUT:
	PRINT #2, s$
	GOTO CYCLE
DUMP:
	PRINT #2, l$
	GOTO CYCLE
NOCODE:
	PRINT "ERROR: Missing ASCII code."
	GOTO HELP
BADCODE:
	PRINT "ERROR: Old and new ASCII codes cannot be identical."
	GOTO HELP
nofind:
	PRINT "ERROR: No file by that name found."
	GOTO HELP
BADFILE:
	PRINT "ERROR: File already exists."
	END
FINISH:
	CLOSE
	IF exists(oldfile$) = YES THEN KILL oldfile$
	NAME infile$ AS oldfile$
	NAME outfile$ AS infile$
	PRINT ""
	PRINT "  Finish time: "; TIME$
	END
ASCII:
	CLS
	FOR c = 0 TO 255
		LOCATE INT(c - (INT(c / 20) * 20) + 1), INT(c / 20) * 6 + 1
		PRINT USING "### "; c;
	IF c = 7 OR (c >= 9 AND c <= 13) OR (c >= 29 AND c <= 31) THEN GOTO BLANK
	COLOR 15: PRINT CHR$(c); : COLOR 7: PRINT CHR$(186)
	GOTO NEXTC
BLANK:
		COLOR 15: PRINT " "; : COLOR 7: PRINT CHR$(186)
NEXTC:
		NEXT c
	LOCATE 22, 1: PRINT "  0 = NULL   7 = BELL   9 = HTAB   10 = LINEFEED   11 = VTAB   12 = FORMFEED"
	LOCATE 23, 1: PRINT " 13 = CARRAGE RETURN   28 = FS   29 = GS   30 = RS   31 = US   32 = SPACE"
	LOCATE 25, 27
	COLOR 15
	PRINT "Hit any key to continue";
	COLOR 7
in: w$ = INKEY$: IF w$ = "" THEN GOTO in
	CLS
	GOTO HELP
filename:                                         'splits infile$ into
		period = INSTR(infile$, ".")              'file$ and ext$
		IF period = 0 THEN
			file$ = infile$
			ext$ = ""
			ELSE
				file$ = LEFT$(infile$, period - 1)

				ext$ = MID$(infile$, period + 1)
		END IF
		RETURN

FUNCTION exists (search$)
	 savefile$ = search$
	 inregs.ax = &H4E00
	 inregs.cx = 1     '3 for hidden
	 search$ = search$ + CHR$(0)
	 inregs.dx = SADD(search$)
	 inregs.ds = -1
	 CALL INTERRUPTX(&H21, inregs, outregs)
	 IF (outregs.flags AND 1) = 1 THEN
			exists = NO
	 ELSE
			exists = YES
	 END IF
	 search$ = savefile$
END FUNCTION

