'RRTS - Remove Redundant Trailing Spaces, vs. 0.0, by Jim Groeneveld, 12/2-91.
'E-mail: GROENEVELD@NIPG.TNO.NL (internet address)         _     _     _      _
'File xfer: GROENEVELD@HDETNO51.BITNET (EARN address)     | |   | |   | \    / |
'NIPG-TNO [postal/visiting address] | Y. Groeneveld       | |   | |   |  \  /  |
'P.O.Box 124    | Wassenaarseweg 56 | Schoolweg 14        | |   | |   |   \/   |
'2300 AC Leiden | 2333 AL Leiden    | 8071 BC Nunspeet _  | |   | |   | |\  /| |
'Nederland (NL) | (+31|0)71-178810  | 03412-60413     | |_| |   | |   | | \/ | |
'[office]     Fax (+31|0)71-176382  | [home]           \___/    |_|   |_|    |_|

' Declare the Comline subprogram, as well as the number and
' type of its parameters.
'''REM $DYNAMIC
DECLARE SUB PrintEmbeddedSpaces (Length%, Nspaces&, OutLength&)
DECLARE SUB Comline (N%, Args$(), Max%)

' Default variable type is integer in this module.
CLEAR : CLOSE : SCREEN 0: WIDTH 80: KEY OFF: DEFINT A-Z: OPTION BASE 1

CONST MaxLineInputLength = 32767 ''' 1000
DimArgs = 15: DIM Args$(1 TO DimArgs)''', DataLine(1 TO 1) AS STRING * 255

PRINT "RRTS - Remove Redundant Trailing Spaces"
PRINT "vs. 0.0, by Jim Groeneveld, 12/2-91"
' Get what was typed on the command line up to two parameters.
CALL Comline(N, Args$(), 2)

' Process arguments into file names
IF Args$(1) = "" THEN
  PRINT "Syntax: RRTS input_file_name output_file_name": BEEP: END
ELSE
  RRTSin$ = Args$(1)' not yet checked for legal syntax or file existence
END IF
IF Args$(2) = "" OR Args$(2) = RRTSin$ THEN
  ' later: rename RRTSin to '.BAK' and so on; for the moment:
  PRINT "Syntax: RRTS input_file_name output_file_name": BEEP: END
ELSE
  RRTSout$ = Args$(2)' not yet checked for legal syntax or file existence
END IF

PRINT : PRINT "Processing "; RRTSin$; " into "; RRTSout$; "......"
' open input and output files
OPEN "I", 1, RRTSin$: OPEN "O", 2, RRTSout$

' read input and write output lines while processing contents
LinesRead& = 0: LinesWritten& = 0: LineParts = 0: Nspaces& = 0: OutLength& = 0
WHILE NOT EOF(1) ''': PRINT FRE(""), FRE(0), FRE(-1), FRE(-2)
  ON ERROR GOTO out.of.string.space: LINE INPUT #1, DataLine$: ON ERROR GOTO 0: LenDataLine& = LEN(DataLine$)
''  DataLine$ = "": ON ERROR GOTO out.of.string.space: DataLine$ = INPUT$(MaxLineInputLength, #1): ON ERROR GOTO 0: LenDataLine& = LEN(DataLine$) ' other alternate
'  DataLine$ = "": LenDataLine& = 0: FOR i = 1 TO MaxLineInputLength' alternate input of long string line (slow)
'    DataChar$ = INPUT$(1, #1)
'    IF DataChar$ = CHR$(13) THEN 'end_of_line
'      DataChar$ = INPUT$(1, #1) ' reads chr$(10)
'      EXIT FOR
'    ELSE
'      DataLine$ = DataLine$ + DataChar$
'      LenDataLine& = LenDataLine& + 1
'      IF LenDataLine& MOD 10 = 0 THEN LOCATE , 1: PRINT "Processing line"; LinesRead& + 1; "with length"; LineParts * MaxLineInputLength + LenDataLine&; ''': PRINT "into length"; OutLength&; SPACE$(10);
'    END IF
'  NEXT i
 
  IF LenDataLine& < MaxLineInputLength THEN
    LinesRead& = LinesRead& + 1: LOCATE , 1: PRINT "Processing line"; LinesRead&; "with length"; LineParts * MaxLineInputLength + LenDataLine&;
    WHILE RIGHT$(DataLine$, 1) = " ": DataLine$ = LEFT$(DataLine$, LEN(DataLine$) - 1): WEND' Remove Redundant Trailing Spaces
'    FOR i = LEN(DataLine$) TO 1 STEP -1' check for spaces from the end
'      IF MID$(DataLine$, i, 1) <> " " THEN LenDataLine& = i: EXIT FOR
'    NEXT i
     CALL PrintEmbeddedSpaces(LEN(DataLine$), Nspaces&, OutLength&)
'    PRINT #2, LEFT$(DataLine$, LenDataLine&): LinesWritten& = LinesWritten& + 1
'    PRINT LenDataLine&; SPACE$(10);
    PRINT #2, DataLine$: LinesWritten& = LinesWritten& + 1: OutLength& = OutLength& + LEN(DataLine$)
    PRINT "into length"; OutLength&; SPACE$(10);
    LineParts = 0: Nspaces& = 0: OutLength& = 0
  ELSE ' {LenDataLine&=MaxLineInputLength} partial line read only, cannot remove spaces because of still unknown contents of next part
    LineParts = LineParts + 1
    WHILE RIGHT$(DataLine$, 1) = " ": DataLine$ = LEFT$(DataLine$, LEN(DataLine$) - 1): WEND' Remove Redundant Trailing Spaces
    CALL PrintEmbeddedSpaces(LEN(DataLine$), Nspaces&, OutLength&)
    Nspaces& = Nspaces& + MaxLineInputLength - LEN(DataLine$)
    PRINT #2, DataLine$; : OutLength& = OutLength& + LEN(DataLine$)
  END IF
WEND

PRINT : PRINT "End of program": CLOSE : END

out.of.string.space: PRINT #2, "*** RRTS - part of long line (>23000 bytes) lost *** "; : RESUME' NEXT

SUB Comline (NumArgs, Args$(), MaxArgs) 'STATIC
CONST TRUE = -1, FALSE = 0
NumArgs = 0: In = FALSE: Quote$ = ""
' Get the command line using the COMMAND$ function.
Cl$ = COMMAND$: L = LEN(Cl$)
' Go through the command line a character at a time.
FOR i = 1 TO L
  C$ = MID$(Cl$, i, 1)
  IF Quote$ <> "" THEN ' Quote is ' or ", wich means: within argument string
    IF C$ = Quote$ THEN
      ' Check for doubled embedded quotes (if I<L)
      IF i < L THEN
        IF MID$(Cl$, i + 1, 1) = Quote$ THEN ' is quote part of doubled one?
          ' add one of the doubled quotes to the argument
          Args$(NumArgs) = Args$(NumArgs) + C$
          i = i + 1' increase character counter
        ELSE ' no doubled quote
          ' end of quoted argument (not yet doubling of embedded quotes)
          Quote$ = ""' Single or double quote not returned as part of the Args$
        END IF
      ELSE ' end of command line reached
        ' end of quoted argument (not yet doubling of embedded quotes)
        Quote$ = ""' Single or double quote not returned as part of the Args$
      END IF
    ELSE
      ' part of quoted argument
      Args$(NumArgs) = Args$(NumArgs) + C$
    END IF
  ELSE ' Quote=""
    ' Test for character being a blank or a tab or a comma.
    IF (C$ <> " " AND C$ <> CHR$(9) AND C$ <> ",") THEN
      ' Neither blank nor tab or comma.
      ' Test to see if you're already inside an argument.
      IF NOT In THEN
        ' You've found the start of a new argument.
        ' Test for too many arguments.
        IF NumArgs = MaxArgs THEN EXIT FOR
        NumArgs = NumArgs + 1
        In = TRUE
      END IF
      ' Test for character being a single or double quote.
      IF (C$ = "'" OR C$ = CHR$(34)) THEN
        Quote$ = C$' Single or double quote not returned as part of the Args$
      ELSE
        ' Add the character to the current argument.
        Args$(NumArgs) = Args$(NumArgs) + C$
      END IF
    ELSE
      ' Found a blank or a tab or a comma, not part of an argument.
      ' Set "Not in an argument" flag to FALSE.
      In = FALSE
    END IF
  END IF
NEXT i
END SUB

SUB PrintEmbeddedSpaces (Length, Nspaces&, OutLength&)
IF Length > 0 THEN ' firstly print embedded spaces
  OutLength& = OutLength& + Nspaces&
  FOR i& = 1 TO INT(Nspaces& / MaxLineInputLength)
    PRINT #2, SPACE$(MaxLineInputLength);
  NEXT i&: PRINT #2, SPACE$(Nspaces& MOD MaxLineInputLength);
  Nspaces& = 0
END IF
END SUB

