@echo off
rem -------------------------------------------------------------
rem  %sndrive%\usr\lib\snuupm\adduser.bat
rem
rem  Adds a new user to the SNUUPM system.
rem  Author: Mike Lawrie (ccml@hippo.ru.ac.za)
rem  Uses ASKENV.EXE from Timo Salmi's tsbat40.zip (ts@uwasa.fi)
rem -------------------------------------------------------------

:getname
askenv Type in the user-id (eg joe) ------------------
set snuupmuser=%ASKENV%
if "%SNUUPMUSER%"=="" goto ends

askenv Type in the name of the user (Joe E. Bloggs) --
set snuupmname=%ASKENV%
if "%SNUUPMNAME%"=="" goto ends

:gotuser
if not exist %sndrive%\usr\%SNUUPMUSER%\%SNUUPMUSER%.rc goto filecheck
echo The user-id %SNUUPMUSER% appears to be in use already
askenv Please confirm that you wish to proceed (y/n) /l
if "%ASKENV%"=="y" goto confirm
if "%ASKENV%"=="n" goto getname
goto gotuser

:filecheck
if not exist %sndrive%\usr\%SNUUPMUSER% goto confirm
echo There is a file called "%sndrive%\usr\%SNUUPMUSER%" which you will
echo have to remove manually, as this name is needed for the
echo user's directory.
pause
goto ends

:confirm
echo ----------------------------------------------------
echo You are about to create USER-ID "%SNUUPMUSER%"
echo              for someone called "%SNUUPMNAME%"
echo ----------------------------------------------------
askenv Is this correct? (y/n) /l
if "%ASKENV%"=="y" goto makedirs
if "%ASKENV%"=="n" goto getname
goto confirm

:makedirs
echo ----------------------------------------------------
if not exist %sndrive%\usr\%SNUUPMUSER%\nul md %sndrive%\usr\%SNUUPMUSER%
if not exist %sndrive%\usr\%SNUUPMUSER%\mail\nul md %sndrive%\usr\%SNUUPMUSER%\mail
if not exist %sndrive%\usr\%SNUUPMUSER%\mbox\nul md %sndrive%\usr\%SNUUPMUSER%\mbox

:passwd
echo %SNUUPMUSER%:*:::%SNUUPMNAME%>> %sndrive%\etc\uupc\passwd

:aliases
echo nickname username@host.domain > %SNUUPMFILE% %sndrive%\usr\%SNUUPMUSER%\aliases.txt

:userrc
set snuupmfile=%sndrive%\usr\%SNUUPMUSER%\%SNUUPMUSER%.rc
echo Name=%SNUUPMNAME%>  %SNUUPMFILE%
echo Mailbox=%SNUUPMUSER%>> %SNUUPMFILE%
echo Home=%sndrive%\usr\%SNUUPMUSER%>> %SNUUPMFILE%
echo Aliases=%sndrive%\usr\%SNUUPMUSER%\aliases.txt>> %SNUUPMFILE%
echo Editor=%editor%>> %SNUUPMFILE%
echo Signature=%sndrive%\usr\%SNUUPMUSER%\mbox\inetsig.pms>> %SNUUPMFILE%

:snewsrc
set snuupmfile=%sndrive%\usr\%SNUUPMUSER%\snews.rc
echo Name=%SNUUPMNAME%>  %SNUUPMFILE%
echo Mailbox=%SNUUPMUSER%>> %SNUUPMFILE%
echo Home=%sndrive%\usr\%SNUUPMUSER%>> %SNUUPMFILE%
echo Aliases=%sndrive%\usr\%SNUUPMUSER%\aliases.txt>> %SNUUPMFILE%
echo Editor=%editor%>> %SNUUPMFILE%
echo Signature=%sndrive%\usr\%SNUUPMUSER%\mbox\inetsig.pms>> %SNUUPMFILE%
echo color helpf whi+>> %SNUUPMFILE%
echo color textf whi+>> %SNUUPMFILE%
echo color headb blu>> %SNUUPMFILE%
echo color headf whi>> %SNUUPMFILE%
echo color msgb blu>> %SNUUPMFILE%
echo color msgf whi>> %SNUUPMFILE%

:signatures
set snuupmfile= %sndrive%\usr\%SNUUPMUSER%\mbox\inetsig.pms
copy %sndrive%\usr\lib\snuupm\utl\blanklin  %SNUUPMFILE%
echo -->> %SNUUPMFILE%
echo %SNUUPMNAME%>> %SNUUPMFILE%
copy %SNUUPMFILE% %sndrive%\usr\%SNUUPMUSER%\mbox\localsig.pms

:ends
set snuupmuser=
set snuupmname=
set snuupmfile=
set askenv=
pause
rem ----ends-----------------------------------------------------
