@if "%debug%"=="" echo off
rem -------------------------------------------------------------
rem  install.bat 
rem  Installs the SNUUPM package.
rem  Creates directories and some newsgroups
rem  Does not destroy or stomp on anything outside the snuupm system
rem  without first asking. If the snuupm working directories already
rem  exist, then ignore the errors from the md commands.
rem -------------------------------------------------------------

Rem set snu_pku=
Rem if exist pkzunzip.exe goto got_pku
Rem for %%d in ( %path% ) do if exist %%d\pkunzip.exe set snu_pku=y
Rem for %%d in ( %path% ) do if exist %%dpkunzip.exe set snu_pku=y
Rem if "%snu_pku%"=="y" goto got_pku
Rem echo PKUNZIP.EXE is not accessible on your computer. It is impossible to
Rem echo install SNUUPM without this program. Install PKUNZIP.EXE so that it is
Rem echo accessible via the PATH environment variable.
Rem pause > nul
Rem goto end
Rem :got_pku
Rem set snu_pku=

:get_drv
if not "%sndrive%"=="" goto got_drv
echo The environment variable SNDRIVE is not set. Double-check that you
echo have followed the instructions in the QUICKSTART section of the 
echo SNUUPMxx.DOC file correctly.
pause
goto end
:got_drv

:chk_drv
if exist %sndrive%\nul goto drv_ok
echo The SNDRIVE environment variable is set to "%sndrive%" which does not
echo appear to be a disk drive on your computer.
pause
goto end
:drv_ok

set snu_p1=%sndrive%\etc\uupc
set snu_p2=%sndrive%\usr\lib\snuupm
set snu_f1=dmenu168.zip pmail235.zip snews190.zip
set snu_f2=uupc11xd.zip uupc11zn.zip uupc11zo.zip uupc11zr.zip

rem -------------------------------------------------------------
rem  Check for the presence of the various packages
for %%i in ( %snu_f1% ) do if not exist %%i goto no_fil
for %%i in ( %snu_f2% ) do if not exist %%i goto no_fil
goto got_pkgs

:no_fil
echo One or more of the following files are missing:-
echo %snu_f1% %snu_f2%
pause
goto end

:got_pkgs
set snu_f1=
set snu_f2=
rem -------------------------------------------------------------
rem  Install the snuupm files.
pkunzip -d snuupm.zip %sndrive%\
rem if "%debug%"=="" del snuupm.zip

echo +--------------------------------------------------+
echo +       Making some directories for snuupm.        +
echo +..................................................+
if not exist %sndrive%\usr\spool\nul md %sndrive%\usr\spool
if not exist %sndrive%\usr\spool\archive\nul md %sndrive%\usr\spool\archive
if not exist %sndrive%\usr\spool\mail\nul md %sndrive%\usr\spool\mail
if not exist %sndrive%\usr\spool\news\nul md %sndrive%\usr\spool\news
if not exist %sndrive%\usr\spool\news\incoming\nul md %sndrive%\usr\spool\news\incoming
if not exist %sndrive%\usr\spool\public\nul md %sndrive%\usr\spool\public
if not exist %sndrive%\usr\root\mail\nul md %sndrive%\usr\root\mail
if not exist %sndrive%\tmp\nul md %sndrive%\tmp
echo +       Directories made                           +
echo +--------------------------------------------------+

rem -------------------------------------------------------------
rem Making the history file - essentially a dummy file.
echo x > %sndrive%\usr\spool\news\history

rem -------------------------------------------------------------
rem Extract the required programs from each package.

pkunzip dmenu168.zip %snu_p2% dougmenu.exe
pkunzip pmail235.zip %snu_p2% pmail.exe pegasus.hlp common.pmd pmdict.pmd pmdict.ndx
pkunzip snews190.zip %snu_p2% addgroup.exe compress.exe expire.exe rmgroup.exe snews.exe unbatch.exe
pkunzip snews190.zip %sndrive%\usr\spool\news ng
pkunzip uupc11xd.zip %snu_p2%\mdm *.mdm
pkunzip uupc11xd.zip %snu_p2% aliases.txt
pkunzip uupc11zn.zip %snu_p2% rnews.exe
pkunzip uupc11zo.zip %snu_p2% uux.com uucp.com uustat.com
pkunzip uupc11zr.zip %snu_p2% rmail.exe uucico.exe uuxqt.exe

rem -------------------------------------------------------------
rem  Let's have a go at setting up the configuration for this computer
rem -------------------------------------------------------------
echo.
echo.
echo.
echo.
echo +------------------------------------------------------------------+
echo + Please provide configuration information regarding your computer +
echo +------------------------------------------------------------------+
:get_host
echo You need to provide a name for your computer. This should be
echo at most 7 characters long, and should start with a letter.
%sndrive%\usr\lib\snuupm\askenv Enter the name of this computer ---- /l
if "%askenv%"=="" goto get_host
set snu_host=%askenv%

:get_dom
echo.
echo You need to provide a domain name, such as "ru.ac.za", "alt.za"
echo or the artificial domain "uucp".
%sndrive%\usr\lib\snuupm\askenv Enter the domain name -------------- /l
if "%askenv%"=="" goto get_dom
set snu_dom=%askenv%

:get_org
echo.
echo Select a name for your setup, like "Bloggs's SNUUPM System"
%sndrive%\usr\lib\snuupm\askenv Name your organization -------------
if "%askenv%"=="" goto get_org
set snu_org=%askenv%

:get_mdm
echo.
echo Choose a modem configuration file from one of these. You might have
echo to edit this file (as %sndrive%\etc\uupc\modem.mdm) once the installation
echo is complete.
for %%m in (%sndrive%\usr\lib\snuupm\mdm\*.mdm) do echo %%m
%sndrive%\usr\lib\snuupm\askenv Which .MDM file do you want -------- /l
if "%askenv%"=="" goto get_mdm
if exist %sndrive%\usr\lib\snuupm\mdm\%askenv%.mdm goto got_mdm
echo You have made a mistake - try again.
echo Type only the stem of the modem filename, do not type the full path
echo and do not type the trailing .MDM
pause
goto get_mdm
:got_mdm
set snu_mdm=%askenv%

:get_baud
echo.
%sndrive%\usr\lib\snuupm\askenv What is the PC-to-Modem baud rate --
if "%askenv%"=="" goto get_baud
set snu_baud=%askenv%

:get_mailserver
echo.
echo Provide the name of the mailserver to which you will connect. This would
echo be something like "kudu".
%sndrive%\usr\lib\snuupm\askenv Enter the name of the mailserver --- /l
if "%askenv%"=="" goto get_mailserver
set snu_mailserver=%askenv%

:get_phone
echo.
echo Provide the phone number of the mailserver %snu_mailserver%, complete
echo with any international and area codes that are necessary.
echo For example, if you connect to kudu
echo                               from within Grahamstown   311081
echo                              from within South Africa   0461311081
echo                             from outside South Africa   +27461311081
%sndrive%\usr\lib\snuupm\askenv Enter the phone number -------------
if "%askenv%"=="" goto get_phone
set snu_phone=%askenv%

:get_passwd
echo.
echo Your computer has to be registered on the mailing host, and so has a
echo password on that mailing host.
%sndrive%\usr\lib\snuupm\askenv Enter the password on mailing host -
if "%askenv%"=="" goto get_passwd
set snu_passwd=%askenv%

rem -------------------------------------------------------------
:check
cls
echo Please confirm that the following is correct:-
echo ---------------------------------------------------------------------
echo.	
echo   Your computer is called......................... %snu_host%
echo.	
echo   It is registered in domain...................... %snu_dom%
echo.	
echo   It operates in the organization................. %snu_org%
echo.	
echo   Your modem is................................... %snu_mdm%
echo.	
echo       and it operates at a baud rate of........... %snu_baud%
echo.	
echo   You will connect to the mailserver called....... %snu_mailserver%
echo.	
echo       at telephone number......................... %snu_phone%
echo.	
echo   The password of your computer on the server is.. %snu_passwd%
echo.	
echo ---------------------------------------------------------------------
%sndrive%\usr\lib\snuupm\askenv Is the above correct (y/n) /l
if not "%askenv%"=="y" goto get_host
echo ---------------------------------------------------------------------

echo Creating the systems file
call %sndrive%\usr\lib\snuupm\utl\systems.bat

echo Creating the modem file
copy %sndrive%\usr\lib\snuupm\mdm\%snu_mdm%.mdm %sndrive%\etc\uupc\modem.mdm

echo Creating the permissn file
call %sndrive%\usr\lib\snuupm\utl\permissn.bat

echo Creating the uupc.rc file
call %sndrive%\usr\lib\snuupm\utl\uupcrc.bat

echo Creating the passwd file
call %sndrive%\usr\lib\snuupm\utl\passwd.bat

echo Creating the user called "root"
call %sndrive%\usr\lib\snuupm\utl\root.bat

echo Creating a few news groups.
call %sndrive%\usr\lib\snuupm\active

echo Creating callout.bat
call %sndrive%\usr\lib\snuupm\utl\calloutx.bat

echo Creating the login banner
call %sndrive%\usr\lib\snuupm\utl\banner.bat

echo Creating snuupm.bat
call %sndrive%\usr\lib\snuupm\utl\snuupm1.bat

rem -------------------------------------------------------------
rem  Compress the SNUUPM executable programs using PKLITE
rem -------------------------------------------------------------

echo You will save about 330 Kb of disk space if you use PKLITE to
echo compress the .COM and .EXE file of SNUUPM. You need to supply
echo PKLITE.EXE yourself (ie it is not part of the SNUUPM package)
%sndrive%\usr\lib\snuupm\askenv Do you want to compress the executables? (y/n) /l
if not "%askenv%"=="y" goto no_pkl

set snu_pkf1=addgroup compress dougmenu expire pmail rmgroup
set snu_pkf2=rmail rnews snews unbatch uucico uucp uustat uux uuxqt
for %%f in ( %snu_pkf1% ) do pklite %sndrive%\usr\lib\snuupm\%%f
for %%f in ( %snu_pkf2% ) do pklite %sndrive%\usr\lib\snuupm\%%f
set snu_pkf1=
set snu_pkf2=

:no_pkl
echo ---------------------------------------------------------------------

rem -------------------------------------------------------------
rem  Make the spool directories for the mailserver
rem -------------------------------------------------------------
if not exist %sndrive%\usr\spool\%snu_mailserver%/nul md %sndrive%\usr\spool\%snu_mailserver%
if not exist %sndrive%\usr\spool\%snu_mailserver%\c/nul md %sndrive%\usr\spool\%snu_mailserver%\c
if not exist %sndrive%\usr\spool\%snu_mailserver%\d/nul md %sndrive%\usr\spool\%snu_mailserver%\d
if not exist %sndrive%\usr\spool\%snu_mailserver%\x/nul md %sndrive%\usr\spool\%snu_mailserver%\x

set snu_host=
set snu_dom=
set snu_org=
set snu_mdm=
set snu_baud=
set snu_mailserver=
set snu_phone=
set snu_passwd=
set askenv=

if "%editor%"=="" goto noedit
if not exist %editor% goto noedit
echo You will have to edit the file %sndrive%\etc\uupc\modem.mdm to ensure
echo that the correct COM port is being used, that the DIALPREFIX (ATDP or
echo ATDT) is set for pulse or tone dialing, and that the INSPEED value
echo is set correctly. I will try to invoke your favourite editor if you
echo will press any key for me.........
pause > nul
%editor% %sndrive%\etc\uupc\modem.mdm
goto edited

:noedit
echo Edit the file %sndrive%\etc\uupc\modem.mdm to check that the correct COM
echo port is being used and that the INSPEED value is set correctly.

:edited
echo ---------------------------------------------------------------------
echo If the COM port is correct, then type SNUUPM and the package should run.
echo ---------------------------------------------------------------------

:end
set snu_p1=
set snu_p2=
rem ----ends-----------------------------------------------------
