//*************************************************
//*
//* lib2a.c:  demonstrates a dialog box function
//* 			  inside a DLL.
//*
//**************************************************

#define	NOCOMM
#define	_WINDOWS
#define	_WINDLL

#include	<windows.h>
#include <stdlib.h>
#include <stdio.h>
#include "dlls.h"


int FAR PASCAL WEP(int doNothing)
{
	return(1);

}	/* WEP */

//*************************************************************************>

void FAR PASCAL testVars(HWND hWnd, short far *num1, short far *num2)
{
	/* local variable */
	static char string[30];		//scope in DLLs DS
	short val;						//scope in calling Apps SS

	MessageBox(hWnd, "In testVars!", "testVars", MB_OK);

	/* note that 'string' is declared static, thus it can be used in a */
	/* Standard C library routine. 'string' is in the DLLs DS and not */
	/* on the calling Apps SS. Also, pointers num1 and num2 scope is  */
	/* in TESTLIB.DLL SS, which is RODSAPP DS. */
	val= *num1 + *num2;
	itoa(val, string, 10);
	MessageBox(hWnd, string, "debug", MB_OK);

	/* demonstrates a near call inside the library */
	nearCall(hWnd);

} /* testVars */

//**************************************************************************>

void NEAR nearCall(HWND hWnd)
{
	/* local variables */
	char string[20];		//scope in calling Apps SS

	string[0]= 'G';
	string[1]= 'r';
	string[2]= 'e';
	string[3]= 'a';
	string[4]= 't';
	string[5]= '\0';

	/* demonstrates */
	testRoutine(hWnd, string);

} /* nearCall */

//*************************************************************************>

void FAR PASCAL testRoutine(HWND hWnd, char far *string)
{

	MessageBox(hWnd, string, "testRoutine", MB_OK);

} /* testRoutine */

//*************************************************************************>

BOOL FAR PASCAL About(HWND hDlg, unsigned message, WORD wParam, LONG lParam)
{
	switch (message) {

		case WM_INITDIALOG:
			return(TRUE);

		case WM_COMMAND:

			if(wParam == IDOK || wParam == IDCANCEL) {

				EndDialog(hDlg, TRUE);
				return(TRUE);

			}

			break;
	}

	return(FALSE);

} /* About */

