/********************************************************************/
/*   SPAWNO v2.0      XMS/disk swapping replacement for spawn...()  */
/*   (c) Copyright 1990 Ralf Brown  All Rights Reserved 	    */
/*								    */
/*   May be freely copied provided that this copyright notice is    */
/*   not altered or removed.					    */
/********************************************************************/

#include <dos.h>
#include <alloc.h>
#include <string.h>

char *__spawn_env ;

int pascal __spawn_buildenv(char **env)
{
   int seg, i ;
   char far *mem ;
   unsigned int length = 1 ;		  /* take trailing NUL into account */
   char *e ;

   for (i = 0 ; env[i] && *env[i] ; i++)  /* add up the lengths of the variables */
      length += strlen(env[i]) + 1 ;
   mem = (char far *)malloc(length+15) ;  /* get enough to ensure para alignment */
   __spawn_env = (char *) mem ;
   seg = FP_SEG(mem) + ((FP_OFF(mem)+15)>>4) ; /* normalize into paragraph alignment */
   mem = MK_FP(seg,0) ; 		  /* and create a normalized pointer */
   while (*env && **env)		  /* for each environment variable */
      {
      e = *env++ ;			  /* copy the variable */
      do {} while ((*mem++ = *e++) != 0) ;/* including the terminating NUL */
      }
   *mem = '\0' ;                          /* final terminating NUL */
   return seg ;
}

